/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.io;

import java.util.Optional;
import java.util.function.Supplier;
import pw.stamina.mandate.internal.io.SimpleIOEnvironment;
import pw.stamina.mandate.internal.io.streams.StandardErrorStream;
import pw.stamina.mandate.internal.io.streams.StandardInputStream;
import pw.stamina.mandate.internal.io.streams.StandardOutputStream;
import pw.stamina.mandate.io.CommandInput;
import pw.stamina.mandate.io.CommandOutput;
import pw.stamina.mandate.io.IOBuilder;
import pw.stamina.mandate.io.IOEnvironment;

public class SimpleIOBuilder
implements IOBuilder {
    private Supplier<CommandInput> inputStreamSupplier;
    private Supplier<CommandOutput> outputStreamSupplier;
    private Supplier<CommandOutput> errorStreamSupplier;

    @Override
    public IOBuilder usingInputStream(Supplier<CommandInput> inputStreamSupplier) {
        SimpleIOBuilder.checkPrecondition(this.inputStreamSupplier == null, "Standard input stream supplier already provided");
        this.inputStreamSupplier = inputStreamSupplier;
        return this;
    }

    @Override
    public IOBuilder usingOutputStream(Supplier<CommandOutput> outputStreamSupplier) {
        SimpleIOBuilder.checkPrecondition(this.outputStreamSupplier == null, "Standard output stream supplier already provided");
        this.outputStreamSupplier = outputStreamSupplier;
        return this;
    }

    @Override
    public IOBuilder usingErrorStream(Supplier<CommandOutput> errorStreamSupplier) {
        SimpleIOBuilder.checkPrecondition(this.errorStreamSupplier == null, "Standard error stream supplier already provided");
        this.errorStreamSupplier = errorStreamSupplier;
        return this;
    }

    @Override
    public IOEnvironment build() {
        return new SimpleIOEnvironment(Optional.ofNullable(this.inputStreamSupplier).orElseGet(() -> StandardInputStream::get), Optional.ofNullable(this.outputStreamSupplier).orElseGet(() -> StandardOutputStream::get), Optional.ofNullable(this.errorStreamSupplier).orElseGet(() -> StandardErrorStream::get));
    }

    private static void checkPrecondition(boolean assertion, String failureMessage) {
        if (!assertion) {
            throw new IllegalStateException(failureMessage);
        }
    }
}

