/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.parameter;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import pw.stamina.mandate.annotations.Implicit;
import pw.stamina.mandate.annotations.flag.AutoFlag;
import pw.stamina.mandate.annotations.flag.UserFlag;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.execution.parameter.CommandParameterCreationStrategy;
import pw.stamina.mandate.internal.execution.parameter.DeclaredCommandParameter;
import pw.stamina.mandate.internal.execution.parameter.UnsupportedParameterException;
import pw.stamina.mandate.internal.utils.GenericResolver;
import pw.stamina.mandate.internal.utils.PrimitiveArrays;

public enum DefaultCommandParameterFactory implements CommandParameterCreationStrategy
{
    INSTANCE;


    @Override
    public List<CommandParameter> generateCommandParameters(Method backingMethod, CommandContext commandContext) throws UnsupportedParameterException {
        HashSet usedFlags = new HashSet();
        boolean[] reachedOptionals = new boolean[]{false};
        boolean[] reachedRequired = new boolean[]{false};
        return Arrays.stream(backingMethod.getParameters()).map(parameter -> {
            if (!parameter.isAnnotationPresent(Implicit.class)) {
                Class type = parameter.getType();
                AutoFlag autoFlag = parameter.getDeclaredAnnotation(AutoFlag.class);
                UserFlag userFlag = parameter.getDeclaredAnnotation(UserFlag.class);
                if (autoFlag != null || userFlag != null) {
                    if (autoFlag != null && userFlag != null) {
                        throw new UnsupportedParameterException("Parameter " + parameter.getName() + " in method " + backingMethod.getName() + " is annotated as both an automatic and operand-based flag");
                    }
                    if (reachedRequired[0] || reachedOptionals[0]) {
                        throw new UnsupportedParameterException("Parameter " + parameter.getName() + " in method " + backingMethod.getName() + " is annotated as flag, but exists after non-flag parameters");
                    }
                    for (String flag : autoFlag != null ? autoFlag.flag() : userFlag.flag()) {
                        if (usedFlags.add(flag)) continue;
                        throw new UnsupportedParameterException("Parameter " + parameter.getName() + " in method " + backingMethod.getName() + " uses previously declared flag name '" + flag + "'");
                    }
                    if (type == Optional.class) {
                        type = (Class)GenericResolver.typeParametersOf(parameter.getParameterizedType())[0];
                    }
                } else if (type == Optional.class) {
                    reachedOptionals[0] = true;
                    type = (Class)GenericResolver.typeParametersOf(parameter.getParameterizedType())[0];
                } else {
                    if (reachedOptionals[0]) {
                        throw new UnsupportedParameterException("Parameter " + parameter.getName() + " in method " + backingMethod.getName() + " is mandatory, but exists after optional parameters");
                    }
                    reachedRequired[0] = true;
                }
                if (!commandContext.getArgumentHandlers().findArgumentHandler(type).isPresent()) {
                    throw new UnsupportedParameterException(String.format("%s is not a supported parameter type", type.getCanonicalName()));
                }
                if (type.isArray() && !commandContext.getArgumentHandlers().findArgumentHandler(PrimitiveArrays.getBaseComponentType(type.getComponentType())).isPresent()) {
                    throw new UnsupportedParameterException(String.format("Array element %s is not a supported parameter type", type.getCanonicalName()));
                }
                return new DeclaredCommandParameter((Parameter)parameter, type);
            }
            return new DeclaredCommandParameter((Parameter)parameter, parameter.getType());
        }).collect(Collectors.toList());
    }

    public static DefaultCommandParameterFactory getInstance() {
        return INSTANCE;
    }
}

