/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.parameter;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import pw.stamina.mandate.annotations.Implicit;
import pw.stamina.mandate.annotations.meta.Usage;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.utils.GenericResolver;

class DeclaredCommandParameter
implements CommandParameter {
    private final Parameter parameter;
    private final Class type;

    DeclaredCommandParameter(Parameter parameter, Class type) {
        this.parameter = parameter;
        this.type = type;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.parameter.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.parameter.getAnnotations();
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isOptional() {
        return this.parameter.getType() == Optional.class;
    }

    @Override
    public boolean isImplicit() {
        return this.getAnnotation((Class)Implicit.class) != null;
    }

    @Override
    public String getDescription() {
        Usage usage = this.getAnnotation((Class)Usage.class);
        return usage != null ? usage.usage() : "";
    }

    @Override
    public String getLabel() {
        Usage usage = this.getAnnotation((Class)Usage.class);
        return usage != null ? usage.name() : this.parameter.getName();
    }

    @Override
    public Type[] getTypeParameters() {
        return GenericResolver.typeParametersOf(this.parameter.getParameterizedType());
    }

    public String toString() {
        return String.format("DeclaredCommandParameter{name=%s, type=%s, optional=%s, implicit=%s, annotations=%s}", this.getLabel(), this.getType().getCanonicalName(), this.isOptional(), this.isImplicit(), Arrays.toString(this.getAnnotations()));
    }
}

