/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.implicit;

import java.util.Optional;
import java.util.function.Supplier;
import pw.stamina.mandate.execution.argument.ArgumentProvider;

public class ForkedArgumentProvider
implements ArgumentProvider {
    private final ArgumentProvider forkedProvider;
    private final ArgumentProvider thisProvider;

    public ForkedArgumentProvider(ArgumentProvider forkedProvider, ArgumentProvider thisProvider) {
        this.forkedProvider = forkedProvider;
        this.thisProvider = thisProvider;
    }

    @Override
    public <V> void registerProvider(Class<V> valueType, Supplier<? extends V> valueProvider) {
        if (this.thisProvider.isProviderPresent(valueType)) {
            throw new IllegalStateException(String.format("Top-level argument provider already mapped for arguments of type %s", valueType.getCanonicalName()));
        }
        this.thisProvider.registerProvider(valueType, valueProvider);
    }

    @Override
    public <V> Optional<Supplier<? extends V>> findProvider(Class<V> valueType) {
        Optional<Supplier<V>> lookup = this.thisProvider.findProvider(valueType);
        return lookup.isPresent() ? lookup : this.forkedProvider.findProvider(valueType);
    }

    @Override
    public boolean isProviderPresent(Class<?> valueType) {
        return this.thisProvider.isProviderPresent(valueType) || this.forkedProvider.isProviderPresent(valueType);
    }
}

