/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.execution.argument.ArgumentParsingException;
import pw.stamina.mandate.parsing.InputParsingException;

public class OptionalArgumentTypeParameterHandler
implements ArgumentHandler<Optional<?>> {
    @Override
    public Optional<?> parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        Type[] typeParameters = parameter.getTypeParameters();
        ArgumentHandler<?> handlerLookup = commandContext.getArgumentHandlers().findArgumentHandler(OptionalArgumentTypeParameterHandler.reifyType(typeParameters[0])).orElseThrow(() -> new ArgumentParsingException(String.format("%s is not a supported parameter type", typeParameters[0])));
        Type[] resolutionTypes = OptionalArgumentTypeParameterHandler.getTypeParameters(typeParameters[0]);
        return Optional.ofNullable(handlerLookup.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument(input.getRaw()), new OptionalTypeParameter(parameter, resolutionTypes), commandContext));
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        throw new UnsupportedOperationException("Type parameters cannot be used as method parameters");
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Optional.class};
    }

    private static Type[] getTypeParameters(Type initialType) {
        Type[] typeArray;
        if (initialType instanceof ParameterizedType) {
            typeArray = ((ParameterizedType)initialType).getActualTypeArguments();
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = initialType;
        }
        return typeArray;
    }

    private static Class<?> reifyType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private static class OptionalTypeParameter
    implements CommandParameter {
        private final CommandParameter backingParameter;
        private final Type[] typeParameters;

        OptionalTypeParameter(CommandParameter backingParameter, Type ... typeParameters) {
            this.backingParameter = backingParameter;
            this.typeParameters = typeParameters;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.backingParameter.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.backingParameter.getAnnotations();
        }

        @Override
        public Class<?> getType() {
            return (Class)this.typeParameters[0];
        }

        @Override
        public Type[] getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public boolean isOptional() {
            return this.backingParameter.isOptional();
        }

        @Override
        public boolean isImplicit() {
            return this.backingParameter.isImplicit();
        }

        @Override
        public String getDescription() {
            return "An Optional type parameter described as \"" + this.backingParameter.getDescription() + "\"";
        }

        @Override
        public String getLabel() {
            return this.backingParameter.getLabel();
        }
    }
}

