/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.annotations.numeric.IntClamp;
import pw.stamina.mandate.internal.annotations.numeric.RealClamp;
import pw.stamina.mandate.internal.utils.Primitives;
import pw.stamina.mandate.parsing.InputParsingException;

public final class NumberArgumentHandler
implements ArgumentHandler<Number> {
    private static final Predicate<String> HEX_VALIDATOR_PREDICATE = Pattern.compile("^(-|\\+)?(0x|0X|#)[a-fA-F0-9]+$").asPredicate();
    private static final Predicate<String> OCTAL_VALIDATOR_PREDICATE = Pattern.compile("^(-|\\+)?0[1-7][0-7]*$").asPredicate();
    private static final Map<Class<? extends Number>, Function<String, ? extends Number>> NUMBER_DECODERS;

    @Override
    public final Number parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        Class<?> numberClass = Primitives.wrap(parameter.getType());
        Object resultNumber = NumberArgumentHandler.parseNumber(input.getRaw(), numberClass);
        if (numberClass == Float.class || numberClass == Double.class) {
            RealClamp realClamp = parameter.getAnnotation(RealClamp.class);
            if (realClamp != null) {
                double min = Math.min(realClamp.min(), realClamp.max());
                if (!Double.isNaN(min) && ((Number)resultNumber).doubleValue() < min) {
                    resultNumber = numberClass == Float.class ? (double)((float)min) : min;
                } else {
                    double max = Math.max(realClamp.min(), realClamp.max());
                    if (!Double.isNaN(max) && ((Number)resultNumber).doubleValue() > max) {
                        resultNumber = numberClass == Float.class ? (double)((float)max) : max;
                    }
                }
            }
        } else {
            IntClamp intClamp = parameter.getAnnotation(IntClamp.class);
            if (intClamp != null) {
                Long min = Math.min(intClamp.min(), intClamp.max());
                if (((Number)resultNumber).longValue() < min) {
                    resultNumber = NumberArgumentHandler.parseNumber(min.toString(), numberClass);
                } else {
                    Long max = Math.max(intClamp.min(), intClamp.max());
                    if (((Number)resultNumber).longValue() > max) {
                        resultNumber = NumberArgumentHandler.parseNumber(max.toString(), numberClass);
                    }
                }
            }
        }
        return resultNumber;
    }

    @Override
    public final String getSyntax(CommandParameter parameter) {
        String suffix;
        Class<?> numberClass = Primitives.wrap(parameter.getType());
        String prefix = numberClass.getSimpleName();
        if (numberClass == Float.class || numberClass == Double.class) {
            RealClamp realClamp = parameter.getAnnotation(RealClamp.class);
            if (realClamp == null) {
                return parameter.getLabel() + " - " + prefix;
            }
            double min = Math.min(realClamp.min(), realClamp.max());
            double max = Math.max(realClamp.min(), realClamp.max());
            suffix = !Double.isNaN(min) && !Double.isNaN(max) ? String.format("%s-%s", min, max) : (!Double.isNaN(min) ? ">" + min : (!Double.isNaN(max) ? "<" + max : "?"));
        } else {
            IntClamp intClamp = parameter.getAnnotation(IntClamp.class);
            if (intClamp == null) {
                return parameter.getLabel() + " - " + prefix;
            }
            long min = Math.min(intClamp.min(), intClamp.max());
            long max = Math.max(intClamp.min(), intClamp.max());
            suffix = Long.MIN_VALUE != min && Long.MAX_VALUE != max ? String.format("%s-%s", min, max) : (Long.MIN_VALUE != min ? ">" + min : (Long.MAX_VALUE != max ? "<" + max : "?"));
        }
        return parameter.getLabel() + " - " + String.format("%s[%s]", prefix, suffix);
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Number.class};
    }

    private static <R extends Number> R parseNumber(String input, Class<R> numberClass) throws InputParsingException {
        try {
            Function<String, ? extends Number> decoder = NUMBER_DECODERS.get(numberClass);
            return (R)((Number)numberClass.cast(decoder.apply(input)));
        }
        catch (NumberFormatException e) {
            throw new InputParsingException(String.format("'%s' cannot be parsed to a(n) %s", input, numberClass.getCanonicalName()), e);
        }
    }

    private static Double decodeDouble(String input) throws NumberFormatException {
        return HEX_VALIDATOR_PREDICATE.test(input) || OCTAL_VALIDATOR_PREDICATE.test(input) ? Long.decode(input).doubleValue() : Double.valueOf(input).doubleValue();
    }

    private static Float decodeFloat(String input) throws NumberFormatException {
        return Float.valueOf(HEX_VALIDATOR_PREDICATE.test(input) || OCTAL_VALIDATOR_PREDICATE.test(input) ? Integer.decode(input).floatValue() : Float.valueOf(input).floatValue());
    }

    private static BigInteger decodeBigInteger(String input) throws NumberFormatException {
        return HEX_VALIDATOR_PREDICATE.test(input) ? new BigInteger(input.charAt(0) == '0' ? input.substring(2) : input.substring(1), 16) : new BigInteger(input, OCTAL_VALIDATOR_PREDICATE.test(input) ? 8 : 10);
    }

    private static BigDecimal decodeBigDecimal(String input) throws NumberFormatException {
        return HEX_VALIDATOR_PREDICATE.test(input) ? new BigDecimal(new BigInteger(input.charAt(0) == '0' ? input.substring(2) : input.substring(1), 16)) : (OCTAL_VALIDATOR_PREDICATE.test(input) ? new BigDecimal(new BigInteger(input, 8)) : new BigDecimal(input));
    }

    static {
        HashMap<Class, Function<String, Number>> decoders = new HashMap<Class, Function<String, Number>>();
        decoders.put(Byte.class, Byte::decode);
        decoders.put(Short.class, Short::decode);
        decoders.put(Integer.class, Integer::decode);
        decoders.put(Long.class, Long::decode);
        decoders.put(Double.class, NumberArgumentHandler::decodeDouble);
        decoders.put(Float.class, NumberArgumentHandler::decodeFloat);
        decoders.put(BigInteger.class, NumberArgumentHandler::decodeBigInteger);
        decoders.put(BigDecimal.class, NumberArgumentHandler::decodeBigDecimal);
        NUMBER_DECODERS = Collections.unmodifiableMap(decoders);
    }
}

