/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.annotations.Length;
import pw.stamina.mandate.internal.execution.argument.ArgumentParsingException;
import pw.stamina.mandate.parsing.InputParsingException;

public class MapArgumentHandler
implements ArgumentHandler<Map<?, ?>> {
    @Override
    public Map<?, ?> parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        Length length;
        char[] inputChars;
        Type[] typeParameters = parameter.getTypeParameters();
        ArgumentHandler<?> keyHandlerLookup = commandContext.getArgumentHandlers().findArgumentHandler(MapArgumentHandler.reifyType(typeParameters[0])).orElseThrow(() -> new ArgumentParsingException(String.format("%s is not a supported parameter type", typeParameters[0])));
        ArgumentHandler<?> valueHandlerLookup = commandContext.getArgumentHandlers().findArgumentHandler(MapArgumentHandler.reifyType(typeParameters[1])).orElseThrow(() -> new ArgumentParsingException(String.format("%s is not a supported parameter type", typeParameters[1])));
        LinkedHashMap<String, String> rawComponents = new LinkedHashMap<String, String>();
        StringBuilder rawKey = new StringBuilder(input.getRaw().length());
        StringBuilder rawValue = new StringBuilder(input.getRaw().length());
        ParsingStage currentStage = ParsingStage.KEY;
        boolean escaped = false;
        boolean quoted = false;
        int depth = 0;
        block29: for (int idx = 1; idx < (inputChars = input.getRaw().toCharArray()).length - 1; ++idx) {
            if (escaped) {
                switch (currentStage) {
                    case KEY: {
                        rawKey.append(inputChars[idx]);
                        break;
                    }
                    case VALUE: {
                        rawValue.append(inputChars[idx]);
                    }
                }
                escaped = false;
                continue;
            }
            switch (inputChars[idx]) {
                case '\\': {
                    escaped = true;
                    continue block29;
                }
                case '\"': {
                    quoted = !quoted;
                    continue block29;
                }
                case ']': 
                case '}': {
                    if (!quoted) {
                        --depth;
                    }
                    switch (currentStage) {
                        case KEY: {
                            rawKey.append(inputChars[idx]);
                            break;
                        }
                        case VALUE: {
                            rawValue.append(inputChars[idx]);
                        }
                    }
                    continue block29;
                }
                case '[': 
                case '{': {
                    if (!quoted) {
                        ++depth;
                    }
                    switch (currentStage) {
                        case KEY: {
                            rawKey.append(inputChars[idx]);
                            break;
                        }
                        case VALUE: {
                            rawValue.append(inputChars[idx]);
                        }
                    }
                    continue block29;
                }
                case '-': {
                    if (!quoted && depth == 0) {
                        if (inputChars[idx + 1] != '>' || currentStage != ParsingStage.KEY) continue block29;
                        currentStage = ParsingStage.VALUE;
                        ++idx;
                        continue block29;
                    }
                    switch (currentStage) {
                        case KEY: {
                            rawKey.append(inputChars[idx]);
                            break;
                        }
                        case VALUE: {
                            rawValue.append(inputChars[idx]);
                        }
                    }
                    continue block29;
                }
                case ',': {
                    if (!quoted && depth == 0) {
                        while (inputChars[idx + 1] == ' ') {
                            ++idx;
                        }
                        if (rawKey.length() <= 0 || rawValue.length() <= 0) continue block29;
                        rawComponents.put(rawKey.toString(), rawValue.toString());
                        rawKey.setLength(0);
                        rawValue.setLength(0);
                        currentStage = ParsingStage.KEY;
                        continue block29;
                    }
                }
                case ' ': {
                    if (!quoted && depth == 0) {
                        if (inputChars[idx + 1] == '-' || inputChars[idx - 1] == '>') continue block29;
                        ++idx;
                        continue block29;
                    }
                }
                default: {
                    switch (currentStage) {
                        case KEY: {
                            rawKey.append(inputChars[idx]);
                            break;
                        }
                        case VALUE: {
                            rawValue.append(inputChars[idx]);
                        }
                    }
                    escaped = false;
                }
            }
        }
        if (rawKey.length() > 0 && rawValue.length() > 0) {
            rawComponents.put(rawKey.toString(), rawValue.toString());
            rawKey.setLength(0);
            rawValue.setLength(0);
        }
        if ((length = parameter.getAnnotation(Length.class)) != null) {
            int min = Math.min(length.min(), length.max());
            int max = Math.max(length.min(), length.max());
            if (rawComponents.size() < min) {
                throw new ArgumentParsingException(String.format("'%s' is too short: length can be between %d-%d mappings", input.getRaw(), min, max));
            }
            if (rawComponents.size() > max) {
                throw new ArgumentParsingException(String.format("'%s' is too long: length can be between %d-%d mappings", input.getRaw(), min, max));
            }
        }
        Type[] keyResolutionTypes = MapArgumentHandler.getTypeParameters(typeParameters[0]);
        Type[] valueResolutionTypes = MapArgumentHandler.getTypeParameters(typeParameters[1]);
        return rawComponents.entrySet().stream().map(entry -> new AbstractMap.SimpleImmutableEntry(keyHandlerLookup.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument((String)entry.getKey()), new MapProxyCommandParameter(parameter, keyResolutionTypes), commandContext), valueHandlerLookup.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument((String)entry.getValue()), new MapProxyCommandParameter(parameter, valueResolutionTypes), commandContext))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        Length length = parameter.getAnnotation(Length.class);
        if (length != null) {
            return parameter.getLabel() + " - " + String.format("Map<%s -> %s>[length=%d-%d]", parameter.getTypeParameters()[0].getTypeName(), parameter.getTypeParameters()[1].getTypeName(), Math.min(length.min(), length.max()), Math.max(length.min(), length.max()));
        }
        return parameter.getLabel() + " - " + String.format("Map<%s -> %s>", parameter.getTypeParameters()[0].getTypeName(), parameter.getTypeParameters()[1].getTypeName());
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Map.class};
    }

    private static Type[] getTypeParameters(Type initialType) {
        Type[] typeArray;
        if (initialType instanceof ParameterizedType) {
            typeArray = ((ParameterizedType)initialType).getActualTypeArguments();
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = initialType;
        }
        return typeArray;
    }

    private static Class<?> reifyType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private static enum ParsingStage {
        KEY,
        VALUE;

    }

    private static class MapProxyCommandParameter
    implements CommandParameter {
        private final CommandParameter backingParameter;
        private final Type[] typeParameters;

        MapProxyCommandParameter(CommandParameter backingParameter, Type ... typeParameters) {
            this.backingParameter = backingParameter;
            this.typeParameters = typeParameters;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.backingParameter.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.backingParameter.getAnnotations();
        }

        @Override
        public Class<?> getType() {
            return (Class)this.typeParameters[0];
        }

        @Override
        public Type[] getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public boolean isOptional() {
            return this.backingParameter.isOptional();
        }

        @Override
        public boolean isImplicit() {
            return this.backingParameter.isImplicit();
        }

        @Override
        public String getDescription() {
            return "An entry in a Map described as \"" + this.backingParameter.getDescription() + "\"";
        }

        @Override
        public String getLabel() {
            return this.backingParameter.getLabel();
        }
    }
}

