/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.annotations.Length;
import pw.stamina.mandate.internal.execution.argument.ArgumentParsingException;
import pw.stamina.mandate.parsing.InputParsingException;

public class ListArgumentHandler
implements ArgumentHandler<List<?>> {
    @Override
    public List<?> parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        Length length;
        char[] inputChars;
        Type[] typeParameters = parameter.getTypeParameters();
        ArgumentHandler<?> handlerLookup = commandContext.getArgumentHandlers().findArgumentHandler(ListArgumentHandler.reifyType(typeParameters[0])).orElseThrow(() -> new ArgumentParsingException(String.format("%s is not a supported parameter type", typeParameters[0])));
        ArrayList<String> rawComponents = new ArrayList<String>();
        StringBuilder rawComponent = new StringBuilder(input.getRaw().length());
        boolean escaped = false;
        boolean quoted = false;
        int depth = 0;
        block8: for (int idx = 1; idx < (inputChars = input.getRaw().toCharArray()).length - 1; ++idx) {
            if (escaped) {
                rawComponent.append(inputChars[idx]);
                escaped = false;
                continue;
            }
            switch (inputChars[idx]) {
                case '\\': {
                    escaped = true;
                    continue block8;
                }
                case '\"': {
                    quoted = !quoted;
                    continue block8;
                }
                case ']': 
                case '}': {
                    if (!quoted) {
                        --depth;
                    }
                    rawComponent.append(inputChars[idx]);
                    continue block8;
                }
                case '[': 
                case '{': {
                    if (!quoted) {
                        ++depth;
                    }
                    rawComponent.append(inputChars[idx]);
                    continue block8;
                }
                case ',': {
                    if (!quoted && depth == 0) {
                        while (inputChars[idx + 1] == ' ') {
                            ++idx;
                        }
                        if (rawComponent.length() <= 0) continue block8;
                        rawComponents.add(rawComponent.toString());
                        rawComponent.setLength(0);
                        continue block8;
                    }
                }
                case ' ': {
                    if (!quoted && depth == 0) {
                        if (inputChars[idx - 1] != ' ' && inputChars[idx - 1] != ',') {
                            throw new ArgumentParsingException("List element at position " + idx + " is separated by space, but not comma delimited");
                        }
                        ++idx;
                        continue block8;
                    }
                }
                default: {
                    rawComponent.append(inputChars[idx]);
                    escaped = false;
                }
            }
        }
        if (rawComponent.length() > 0) {
            rawComponents.add(rawComponent.toString());
            rawComponent.setLength(0);
        }
        if ((length = parameter.getAnnotation(Length.class)) != null) {
            int min = Math.min(length.min(), length.max());
            int max = Math.max(length.min(), length.max());
            if (rawComponents.size() < min) {
                throw new ArgumentParsingException(String.format("'%s' is too short: length can be between %d-%d elements", input.getRaw(), min, max));
            }
            if (rawComponents.size() > max) {
                throw new ArgumentParsingException(String.format("'%s' is too long: length can be between %d-%d elements", input.getRaw(), min, max));
            }
        }
        Type[] resolutionTypes = ListArgumentHandler.getTypeParameters(typeParameters[0]);
        return rawComponents.stream().map(component -> handlerLookup.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument((String)component), new ListProxyCommandParameter(parameter, resolutionTypes), commandContext)).collect(Collectors.toList());
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        Length length = parameter.getAnnotation(Length.class);
        if (length != null) {
            return parameter.getLabel() + " - " + String.format("List<%s>[length=%d-%d]", parameter.getTypeParameters()[0].getTypeName(), Math.min(length.min(), length.max()), Math.max(length.min(), length.max()));
        }
        return parameter.getLabel() + " - " + String.format("List<%s>", parameter.getTypeParameters()[0].getTypeName());
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{List.class};
    }

    private static Type[] getTypeParameters(Type initialType) {
        Type[] typeArray;
        if (initialType instanceof ParameterizedType) {
            typeArray = ((ParameterizedType)initialType).getActualTypeArguments();
        } else {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = initialType;
        }
        return typeArray;
    }

    private static Class<?> reifyType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    private static class ListProxyCommandParameter
    implements CommandParameter {
        private final CommandParameter backingParameter;
        private final Type[] typeParameters;

        ListProxyCommandParameter(CommandParameter backingParameter, Type ... typeParameters) {
            this.backingParameter = backingParameter;
            this.typeParameters = typeParameters;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.backingParameter.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.backingParameter.getAnnotations();
        }

        @Override
        public Class<?> getType() {
            return (Class)this.typeParameters[0];
        }

        @Override
        public Type[] getTypeParameters() {
            return this.typeParameters;
        }

        @Override
        public boolean isOptional() {
            return this.backingParameter.isOptional();
        }

        @Override
        public boolean isImplicit() {
            return this.backingParameter.isImplicit();
        }

        @Override
        public String getDescription() {
            return "An element in a List described as \"" + this.backingParameter.getDescription() + "\"";
        }

        @Override
        public String getLabel() {
            return this.backingParameter.getLabel();
        }
    }
}

