/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.util.regex.Pattern;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.annotations.strings.Equals;
import pw.stamina.mandate.parsing.InputParsingException;

public final class CharacterArgumentHandler
implements ArgumentHandler<Character> {
    @Override
    public Character parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        if (!input.getRaw().isEmpty()) {
            return null;
        }
        Equals equals = parameter.getAnnotation(Equals.class);
        if (equals != null) {
            for (String string : equals.value()) {
                if (!(equals.regex() ? Pattern.compile(string).matcher(input.getRaw()).matches() : string.equalsIgnoreCase(input.getRaw()))) continue;
                return Character.valueOf(input.getRaw().charAt(0));
            }
            throw new InputParsingException(String.format("'%s' doesn't match ['%s'] (regex=%s)", input.getRaw(), String.join((CharSequence)" / ", equals.value()), equals.regex()));
        }
        return Character.valueOf(input.getRaw().charAt(0));
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        Equals equals = parameter.getAnnotation(Equals.class);
        if (equals != null) {
            return parameter.getLabel() + " - " + String.format("Character['%s', regex=%s]", String.join((CharSequence)" / ", equals.value()), equals.regex());
        }
        return parameter.getLabel() + " - Character";
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Character.class};
    }
}

