/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.parsing.InputParsingException;

public final class BooleanArgumentHandler
implements ArgumentHandler<Boolean> {
    private static final Map<String, Boolean> BOOLEAN_LOOKUPS;

    @Override
    public Boolean parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        return Optional.ofNullable(BOOLEAN_LOOKUPS.get(input.getRaw().toLowerCase())).orElseThrow(() -> new InputParsingException(String.format("'%s' cannot be parsed to a boolean.", input)));
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        return parameter.getLabel() + " - Boolean";
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Boolean.class};
    }

    static {
        HashMap lookups = new HashMap();
        Arrays.asList("enable", "true", "yes", "on", "1").forEach(x -> lookups.put(x, true));
        Arrays.asList("disable", "false", "off", "no", "0").forEach(x -> lookups.put(x, false));
        BOOLEAN_LOOKUPS = Collections.unmodifiableMap(lookups);
    }
}

