/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument.handlers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.parameter.CommandParameter;
import pw.stamina.mandate.internal.annotations.Length;
import pw.stamina.mandate.internal.execution.argument.ArgumentParsingException;
import pw.stamina.mandate.internal.utils.PrimitiveArrays;
import pw.stamina.mandate.parsing.InputParsingException;

public final class ArrayArgumentHandler
implements ArgumentHandler<Object> {
    @Override
    public Object parse(CommandArgument input, CommandParameter parameter, CommandContext commandContext) throws InputParsingException {
        Length length;
        char[] inputChars;
        ArgumentHandler<?> handlerLookup = commandContext.getArgumentHandlers().findArgumentHandler(parameter.getType().getComponentType()).orElseThrow(() -> new ArgumentParsingException(String.format("%s is not a supported parameter type", parameter.getType().getComponentType())));
        ArrayList<String> rawComponents = new ArrayList<String>();
        StringBuilder rawComponent = new StringBuilder(input.getRaw().length());
        boolean escaped = false;
        boolean quoted = false;
        int depth = 0;
        block8: for (int idx = 1; idx < (inputChars = input.getRaw().toCharArray()).length - 1; ++idx) {
            if (escaped) {
                rawComponent.append(inputChars[idx]);
                escaped = false;
                continue;
            }
            switch (inputChars[idx]) {
                case '\\': {
                    escaped = true;
                    continue block8;
                }
                case '\"': {
                    quoted = !quoted;
                    continue block8;
                }
                case ']': 
                case '}': {
                    if (!quoted) {
                        --depth;
                    }
                    rawComponent.append(inputChars[idx]);
                    continue block8;
                }
                case '[': 
                case '{': {
                    if (!quoted) {
                        ++depth;
                    }
                    rawComponent.append(inputChars[idx]);
                    continue block8;
                }
                case ',': {
                    if (!quoted && depth == 0) {
                        while (inputChars[idx + 1] == ' ') {
                            ++idx;
                        }
                        if (rawComponent.length() <= 0) continue block8;
                        rawComponents.add(rawComponent.toString());
                        rawComponent.setLength(0);
                        continue block8;
                    }
                }
                case ' ': {
                    if (!quoted && depth == 0) {
                        if (inputChars[idx - 1] != ' ' && inputChars[idx - 1] != ',') {
                            throw new ArgumentParsingException("Array element at position " + idx + " is separated by space, but not comma delimited");
                        }
                        ++idx;
                        continue block8;
                    }
                }
                default: {
                    rawComponent.append(inputChars[idx]);
                    escaped = false;
                }
            }
        }
        if (rawComponent.length() > 0) {
            rawComponents.add(rawComponent.toString());
            rawComponent.setLength(0);
        }
        if ((length = parameter.getAnnotation(Length.class)) != null) {
            int min = Math.min(length.min(), length.max());
            int max = Math.max(length.min(), length.max());
            if (rawComponents.size() < min) {
                throw new ArgumentParsingException(String.format("'%s' is too short: length can be between %d-%d elements", input.getRaw(), min, max));
            }
            if (rawComponents.size() > max) {
                throw new ArgumentParsingException(String.format("'%s' is too long: length can be between %d-%d elements", input.getRaw(), min, max));
            }
        }
        Object resultArray = Array.newInstance(parameter.getType().getComponentType(), rawComponents.size());
        for (int i = 0; i < rawComponents.size(); ++i) {
            Array.set(resultArray, i, handlerLookup.parse(commandContext.getCommandConfiguration().getArgumentCreationStrategy().newArgument((String)rawComponents.get(i)), new ArrayProxyCommandParameter(parameter), commandContext));
        }
        return resultArray;
    }

    @Override
    public String getSyntax(CommandParameter parameter) {
        Length length = parameter.getAnnotation(Length.class);
        if (length != null) {
            return parameter.getLabel() + " - " + String.format("Array(%s%s)[length=%d-%d]", parameter.getType().getComponentType().getSimpleName(), String.join((CharSequence)"", Collections.nCopies(PrimitiveArrays.getDimensions(parameter.getType()).length, "[]")), Math.min(length.min(), length.max()), Math.max(length.min(), length.max()));
        }
        return parameter.getLabel() + " - " + String.format("Array(%s%s)", parameter.getType().getComponentType().getSimpleName(), String.join((CharSequence)"", Collections.nCopies(PrimitiveArrays.getDimensions(parameter.getType()).length, "[]")));
    }

    @Override
    public Class[] getHandledTypes() {
        return new Class[]{Object[].class};
    }

    private static class ArrayProxyCommandParameter
    implements CommandParameter {
        private final CommandParameter backingParameter;

        ArrayProxyCommandParameter(CommandParameter backingParameter) {
            this.backingParameter = backingParameter;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
            return this.backingParameter.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.backingParameter.getAnnotations();
        }

        @Override
        public Class<?> getType() {
            return this.backingParameter.getType().getComponentType();
        }

        @Override
        public Type[] getTypeParameters() {
            return new Type[0];
        }

        @Override
        public boolean isOptional() {
            return this.backingParameter.isOptional();
        }

        @Override
        public boolean isImplicit() {
            return this.backingParameter.isImplicit();
        }

        @Override
        public String getDescription() {
            return "An element in an array described as \"" + this.backingParameter.getDescription() + "\"";
        }

        @Override
        public String getLabel() {
            return this.backingParameter.getLabel();
        }
    }
}

