/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution.argument;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pw.stamina.mandate.execution.argument.ArgumentHandler;
import pw.stamina.mandate.execution.argument.ArgumentHandlerRegistry;
import pw.stamina.mandate.internal.utils.PrimitiveArrays;
import pw.stamina.mandate.internal.utils.Primitives;

public class SimpleArgumentHandlerRegistry
implements ArgumentHandlerRegistry {
    private final Map<Class<?>, ArgumentHandler<?>> argumentHandlers = new HashMap();

    @Override
    public <T> Optional<ArgumentHandler<T>> findArgumentHandler(Class<T> type) {
        if (type.isPrimitive()) {
            type = Primitives.wrap(type);
        } else if (type.isArray()) {
            Class wrappedArray;
            type = wrappedArray = PrimitiveArrays.wrap(type);
        }
        ArgumentHandler<?> handlerLookup = this.argumentHandlers.get(type);
        if (handlerLookup != null) {
            return Optional.of(handlerLookup);
        }
        for (ArgumentHandler<?> argumentHandler : this.argumentHandlers.values()) {
            for (Class handledType : argumentHandler.getHandledTypes()) {
                if (!handledType.isAssignableFrom(type)) continue;
                ArgumentHandler<?> handler = argumentHandler;
                return Optional.of(handler);
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean addArgumentHandler(ArgumentHandler<?> argumentHandler) {
        for (Class handledType : argumentHandler.getHandledTypes()) {
            this.argumentHandlers.put(handledType, argumentHandler);
        }
        return true;
    }
}

