/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution;

import java.util.HashMap;
import java.util.Optional;
import pw.stamina.mandate.execution.CommandConfiguration;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.ContextBuilder;
import pw.stamina.mandate.execution.argument.ArgumentHandlerRegistry;
import pw.stamina.mandate.execution.argument.ArgumentProvider;
import pw.stamina.mandate.internal.execution.DefaultCommandConfiguration;
import pw.stamina.mandate.internal.execution.DefaultCommandContext;
import pw.stamina.mandate.internal.execution.argument.DefaultArgumentHandlerRegistry;
import pw.stamina.mandate.internal.execution.argument.ForkedArgumentHandlerRegistry;
import pw.stamina.mandate.internal.execution.argument.implicit.ArgumentProviderFactory;
import pw.stamina.mandate.internal.execution.argument.implicit.ForkedArgumentProvider;
import pw.stamina.mandate.internal.io.DefaultIOEnvironment;
import pw.stamina.mandate.internal.syntax.ForkedCommandRegistry;
import pw.stamina.mandate.internal.syntax.SimpleCommandRegistry;
import pw.stamina.mandate.io.IOEnvironment;
import pw.stamina.mandate.syntax.CommandRegistry;

public class SimpleContextBuilder
implements ContextBuilder {
    private IOEnvironment ioEnvironment;
    private CommandConfiguration commandConfiguration;
    private ArgumentHandlerRegistry argumentHandlerRegistry;
    private CommandRegistry commandRegistry;
    private ArgumentProvider argumentProvider;

    @Override
    public ContextBuilder usingIOEnvironment(IOEnvironment ioEnvironment) {
        SimpleContextBuilder.checkPrecondition(this.ioEnvironment == null, "IO Environment has already been supplied");
        this.ioEnvironment = ioEnvironment;
        return this;
    }

    @Override
    public ContextBuilder usingConfiguration(CommandConfiguration commandConfiguration) {
        SimpleContextBuilder.checkPrecondition(this.commandConfiguration == null, "Command Configuration has already been supplied");
        this.commandConfiguration = commandConfiguration;
        return this;
    }

    @Override
    public ContextBuilder withHandlerRegistry(ArgumentHandlerRegistry argumentHandlerRegistry) {
        if (this.argumentHandlerRegistry == null) {
            this.argumentHandlerRegistry = new DefaultArgumentHandlerRegistry();
        }
        this.argumentHandlerRegistry = new ForkedArgumentHandlerRegistry(this.argumentHandlerRegistry, argumentHandlerRegistry);
        return this;
    }

    @Override
    public ContextBuilder withCommandRegistry(CommandRegistry commandRegistry) {
        this.commandRegistry = this.commandRegistry == null ? commandRegistry : new ForkedCommandRegistry(this.commandRegistry, commandRegistry);
        return this;
    }

    @Override
    public ContextBuilder withArgumentProvider(ArgumentProvider argumentProvider) {
        this.argumentProvider = this.argumentProvider == null ? argumentProvider : new ForkedArgumentProvider(this.argumentProvider, argumentProvider);
        return this;
    }

    @Override
    public CommandContext build() {
        return new DefaultCommandContext(Optional.ofNullable(this.ioEnvironment).orElseGet(DefaultIOEnvironment::getInstance), Optional.ofNullable(this.commandConfiguration).orElseGet(DefaultCommandConfiguration::getInstance), Optional.ofNullable(this.argumentHandlerRegistry).orElseGet(DefaultArgumentHandlerRegistry::new), Optional.ofNullable(this.commandRegistry).orElseGet(SimpleCommandRegistry::new), Optional.ofNullable(this.argumentProvider).orElseGet(() -> ArgumentProviderFactory.fromMapping(new HashMap())));
    }

    private static void checkPrecondition(boolean assertion, String failureMessage) {
        if (!assertion) {
            throw new IllegalStateException(failureMessage);
        }
    }
}

