/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution;

import java.util.Optional;
import pw.stamina.mandate.execution.CommandConfiguration;
import pw.stamina.mandate.execution.ConfigurationBuilder;
import pw.stamina.mandate.execution.argument.CommandArgumentCreationStrategy;
import pw.stamina.mandate.execution.executable.CommandExecutableCreationStrategy;
import pw.stamina.mandate.execution.parameter.CommandParameterCreationStrategy;
import pw.stamina.mandate.internal.execution.SimpleCommandConfiguration;
import pw.stamina.mandate.internal.execution.argument.DefaultCommandArgumentFactory;
import pw.stamina.mandate.internal.execution.executable.DefaultCommandExecutableFactory;
import pw.stamina.mandate.internal.execution.parameter.DefaultCommandParameterFactory;
import pw.stamina.mandate.internal.parsing.DefaultArgumentReifier;
import pw.stamina.mandate.internal.parsing.DefaultInputTokenizer;
import pw.stamina.mandate.internal.syntax.component.DefaultSyntaxComponentFactory;
import pw.stamina.mandate.parsing.ArgumentReificationStrategy;
import pw.stamina.mandate.parsing.InputTokenizationStrategy;
import pw.stamina.mandate.syntax.SyntaxComponentCreationStrategy;

public class SimpleConfigurationBuilder
implements ConfigurationBuilder {
    private SyntaxComponentCreationStrategy syntaxComponentCreationStrategy;
    private CommandArgumentCreationStrategy commandArgumentCreationStrategy;
    private InputTokenizationStrategy inputTokenizationStrategy;
    private CommandExecutableCreationStrategy executableCreationStrategy;
    private CommandParameterCreationStrategy parameterCreationStrategy;
    private ArgumentReificationStrategy argumentReificationStrategy;

    @Override
    public ConfigurationBuilder usingSyntaxCreationStrategy(SyntaxComponentCreationStrategy syntaxComponentCreationStrategy) {
        SimpleConfigurationBuilder.checkPrecondition(this.syntaxComponentCreationStrategy == null, "SyntaxComponent creation strategy has already been provided");
        this.syntaxComponentCreationStrategy = syntaxComponentCreationStrategy;
        return this;
    }

    @Override
    public ConfigurationBuilder usingArgumentCreationStrategy(CommandArgumentCreationStrategy commandArgumentCreationStrategy) {
        SimpleConfigurationBuilder.checkPrecondition(this.commandArgumentCreationStrategy == null, "CommandArgument creation strategy has already been provided");
        this.commandArgumentCreationStrategy = commandArgumentCreationStrategy;
        return this;
    }

    @Override
    public ConfigurationBuilder usingInputTokenizationStrategy(InputTokenizationStrategy inputTokenizationStrategy) {
        SimpleConfigurationBuilder.checkPrecondition(this.inputTokenizationStrategy == null, "Input tokenization strategy has already been provided");
        this.inputTokenizationStrategy = inputTokenizationStrategy;
        return this;
    }

    @Override
    public ConfigurationBuilder usingExecutableCreationStrategy(CommandExecutableCreationStrategy executableCreationStrategy) {
        SimpleConfigurationBuilder.checkPrecondition(this.executableCreationStrategy == null, "CommandExecutable creation strategy has already been provided");
        this.executableCreationStrategy = executableCreationStrategy;
        return this;
    }

    @Override
    public ConfigurationBuilder usingParameterCreationStrategy(CommandParameterCreationStrategy parameterCreationStrategy) {
        SimpleConfigurationBuilder.checkPrecondition(this.parameterCreationStrategy == null, "CommandParameter creation strategy has already been provided");
        this.parameterCreationStrategy = parameterCreationStrategy;
        return this;
    }

    @Override
    public ConfigurationBuilder usingArgumentReificationStrategy(ArgumentReificationStrategy argumentReificationStrategy) {
        SimpleConfigurationBuilder.checkPrecondition(this.argumentReificationStrategy == null, "Argument reification strategy has already been provided");
        this.argumentReificationStrategy = argumentReificationStrategy;
        return this;
    }

    @Override
    public CommandConfiguration build() {
        return new SimpleCommandConfiguration(Optional.ofNullable(this.syntaxComponentCreationStrategy).orElseGet(DefaultSyntaxComponentFactory::getInstance), Optional.ofNullable(this.commandArgumentCreationStrategy).orElseGet(DefaultCommandArgumentFactory::getInstance), Optional.ofNullable(this.inputTokenizationStrategy).orElseGet(DefaultInputTokenizer::getInstance), Optional.ofNullable(this.executableCreationStrategy).orElseGet(DefaultCommandExecutableFactory::getInstance), Optional.ofNullable(this.parameterCreationStrategy).orElseGet(DefaultCommandParameterFactory::getInstance), Optional.ofNullable(this.argumentReificationStrategy).orElseGet(DefaultArgumentReifier::getInstance));
    }

    private static void checkPrecondition(boolean assertion, String failureMessage) {
        if (!assertion) {
            throw new IllegalStateException(failureMessage);
        }
    }
}

