/*
 * Decompiled with CFR 0.152.
 */
package pw.stamina.mandate.internal.execution;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Deque;
import pw.stamina.mandate.annotations.Executes;
import pw.stamina.mandate.execution.CommandConfiguration;
import pw.stamina.mandate.execution.CommandContext;
import pw.stamina.mandate.execution.ExecutionContext;
import pw.stamina.mandate.execution.argument.ArgumentHandlerRegistry;
import pw.stamina.mandate.execution.argument.ArgumentProvider;
import pw.stamina.mandate.execution.argument.CommandArgument;
import pw.stamina.mandate.execution.result.Execution;
import pw.stamina.mandate.execution.result.ExitCode;
import pw.stamina.mandate.internal.execution.executable.context.ExecutionContextFactory;
import pw.stamina.mandate.io.IODescriptor;
import pw.stamina.mandate.io.IOEnvironment;
import pw.stamina.mandate.parsing.InputTokenizationException;
import pw.stamina.mandate.syntax.CommandRegistry;
import pw.stamina.mandate.syntax.ExecutableLookup;

public class DefaultCommandContext
implements CommandContext {
    private final IOEnvironment ioEnvironment;
    private final CommandConfiguration commandConfiguration;
    private final ArgumentHandlerRegistry argumentHandlerRegistry;
    private final CommandRegistry commandRegistry;
    private final ArgumentProvider providerRepository;

    public DefaultCommandContext(IOEnvironment ioEnvironment, CommandConfiguration commandConfiguration, ArgumentHandlerRegistry argumentHandlerRegistry, CommandRegistry commandRegistry, ArgumentProvider providerRepository) {
        this.ioEnvironment = ioEnvironment;
        this.commandConfiguration = commandConfiguration;
        this.argumentHandlerRegistry = argumentHandlerRegistry;
        this.commandRegistry = commandRegistry;
        this.providerRepository = providerRepository;
    }

    @Override
    public boolean register(Object container) {
        boolean registered = false;
        for (Method method : container.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Executes.class)) continue;
            this.commandConfiguration.getSyntaxCreationStrategy().getComponents(method, container, this).forEach(this.commandRegistry::addCommand);
            registered = true;
        }
        return registered;
    }

    @Override
    public Execution execute(String input, IODescriptor descriptor) {
        Deque<CommandArgument> arguments;
        if (input == null) {
            descriptor.err().write("Invalid input: input cannot be empty");
            return Execution.complete(ExitCode.INVALID);
        }
        if (input.isEmpty()) {
            descriptor.err().write("Invalid input: input cannot be empty");
            return Execution.complete(ExitCode.INVALID);
        }
        try {
            arguments = this.commandConfiguration.getInputTokenizationStrategy().parse(input, this.commandConfiguration.getArgumentCreationStrategy());
        }
        catch (InputTokenizationException e) {
            descriptor.err().write("Exception tokenizing input: " + e.getLocalizedMessage());
            return Execution.complete(ExitCode.INVALID);
        }
        ExecutionContext executionContext = ExecutionContextFactory.makeContext(Collections.singletonMap(IODescriptor.class, descriptor), this.providerRepository);
        ExecutableLookup executableLookup = this.commandRegistry.findExecutable(arguments, executionContext);
        if (executableLookup.wasSuccessful()) {
            return executableLookup.getExecutable().execute(arguments, executionContext);
        }
        descriptor.err().write(executableLookup.getException().getMessage());
        return Execution.complete(ExitCode.INVALID);
    }

    @Override
    public Execution execute(String input) {
        return this.execute(input, this.ioEnvironment.descriptorFactory().get());
    }

    @Override
    public IOEnvironment getIOEnvironment() {
        return this.ioEnvironment;
    }

    @Override
    public CommandConfiguration getCommandConfiguration() {
        return this.commandConfiguration;
    }

    @Override
    public ArgumentHandlerRegistry getArgumentHandlers() {
        return this.argumentHandlerRegistry;
    }

    @Override
    public CommandRegistry getRegisteredCommands() {
        return this.commandRegistry;
    }

    @Override
    public ArgumentProvider getValueProviders() {
        return this.providerRepository;
    }
}

