/*
 * Decompiled with CFR 0.152.
 */
package pw.spn.crawler.livelib.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pw.spn.crawler.livelib.http.LiveLibRequestInterceptor;
import pw.spn.crawler.livelib.http.ResponseWrapper;

public class LivelibHttpService {
    private static final String BASE_URL = "https://www.livelib.ru/apiapp";
    private static final Logger logger = LoggerFactory.getLogger(LivelibHttpService.class);
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public LivelibHttpService() {
        this(new ObjectMapper());
    }

    public LivelibHttpService(ObjectMapper objectMapper) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.addInterceptor((Interceptor)new LiveLibRequestInterceptor());
        okHttpClientBuilder.connectTimeout(2L, TimeUnit.MINUTES).writeTimeout(2L, TimeUnit.MINUTES).readTimeout(2L, TimeUnit.MINUTES);
        this.httpClient = okHttpClientBuilder.build();
        this.objectMapper = objectMapper;
    }

    public <T> Optional<T> doGet(String url, TypeReference<T> entityType) {
        try {
            String jsonResponse = this.httpClient.newCall(new Request.Builder().url(BASE_URL + url).build()).execute().body().string();
            return Optional.ofNullable(this.mapToEntity(jsonResponse, entityType));
        }
        catch (IOException e) {
            logger.error("Error when making request to {}", (Object)(BASE_URL + url));
            return Optional.empty();
        }
    }

    private <T> T mapToEntity(String jsonResponse, TypeReference<T> entityType) throws IOException {
        logger.debug("Response from LiveLib:\n {}", (Object)jsonResponse);
        JavaType type = this.objectMapper.getTypeFactory().constructParametricType(ResponseWrapper.class, new JavaType[]{this.objectMapper.getTypeFactory().constructType(entityType)});
        ResponseWrapper wrapper = (ResponseWrapper)this.objectMapper.readValue(jsonResponse, type);
        return wrapper.getData();
    }
}

