/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player.games.arcade;

import eu.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import eu.beezig.hiveapi.wrapper.monthly.sp.SpMonthlyLeaderboard;
import eu.beezig.hiveapi.wrapper.monthly.sp.SpMonthlyProfile;
import eu.beezig.hiveapi.wrapper.player.PvPStats;
import eu.beezig.hiveapi.wrapper.player.Titleable;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

public class SpStats
extends PvPStats
implements Titleable,
MonthliesReady {
    public SpStats(JObject source) {
        super(source);
    }

    public long getBlocksDestroyed() {
        return this.source.getLong("blocksdestroyed");
    }

    public long getEggsFired() {
        return this.source.getLong("eggsfired");
    }

    public long getTimeAlive() {
        return this.source.getLong("timealive");
    }

    public boolean hasRainbowEggs() {
        return this.source.getBoolean("rainboweggs");
    }

    public boolean isSheepUnlocked() {
        return this.source.getBoolean("sheepunlock");
    }

    public boolean hasShovelUpgrade() {
        return this.source.getBoolean("shovelupgrade");
    }

    @Override
    public long getKills() {
        return -1L;
    }

    @Override
    public long getGamesPlayed() {
        return this.source.getLong("gamesplayed");
    }

    @Override
    public long getPoints() {
        return this.source.getLong("points");
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }

    @Override
    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstlogin") * 1000L);
    }

    public CompletableFuture<SpMonthlyProfile> getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    public CompletableFuture<SpMonthlyProfile> getMonthlyProfile(String uuid) {
        return JObject.get(new UrlBuilder().monthly().sp().profile(uuid).build()).thenApplyAsync(SpMonthlyProfile::new);
    }

    public CompletableFuture<SpMonthlyProfile> getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard(humanPlace, humanPlace).thenApplyAsync(lb -> lb.getProfiles().get(0));
    }

    public CompletableFuture<SpMonthlyLeaderboard> getMonthlyLeaderboard() {
        return JObject.get(new UrlBuilder().monthly().sp().leaderboard().build()).thenApplyAsync(SpMonthlyLeaderboard::new);
    }

    public CompletableFuture<SpMonthlyLeaderboard> getMonthlyLeaderboard(int from, int to) {
        return JObject.get(new UrlBuilder().monthly().sp().leaderboard(from, to).build()).thenApplyAsync(SpMonthlyLeaderboard::new);
    }
}

