/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player.games.arcade;

import eu.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import eu.beezig.hiveapi.wrapper.monthly.draw.DrawMonthlyLeaderboard;
import eu.beezig.hiveapi.wrapper.monthly.draw.DrawMonthlyProfile;
import eu.beezig.hiveapi.wrapper.player.GameStats;
import eu.beezig.hiveapi.wrapper.player.Titleable;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

public class DrawStats
extends GameStats
implements Titleable,
MonthliesReady {
    public DrawStats(JObject source) {
        super(source);
    }

    public long getCorrectGuesses() {
        return this.source.getLong("correct_guesses");
    }

    public long getIncorrectGuesses() {
        return this.source.getLong("incorrect_guesses");
    }

    public long getSkips() {
        return this.source.getLong("skips");
    }

    @Override
    public Date getLastLogin() {
        return null;
    }

    @Override
    public long getGamesPlayed() {
        return this.source.getLong("gamesplayed");
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }

    public CompletableFuture<DrawMonthlyProfile> getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    public CompletableFuture<DrawMonthlyProfile> getMonthlyProfile(String uuid) {
        return JObject.get(new UrlBuilder().monthly().draw().profile(uuid).build()).thenApplyAsync(DrawMonthlyProfile::new);
    }

    public CompletableFuture<DrawMonthlyProfile> getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard(humanPlace, humanPlace).thenApplyAsync(lb -> lb.getProfiles().get(0));
    }

    public CompletableFuture<DrawMonthlyLeaderboard> getMonthlyLeaderboard() {
        return JObject.get(new UrlBuilder().monthly().draw().leaderboard().build()).thenApplyAsync(DrawMonthlyLeaderboard::new);
    }

    public CompletableFuture<DrawMonthlyLeaderboard> getMonthlyLeaderboard(int from, int to) {
        return JObject.get(new UrlBuilder().monthly().draw().leaderboard(from, to).build()).thenApplyAsync(DrawMonthlyLeaderboard::new);
    }
}

