/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player.games.arcade;

import eu.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import eu.beezig.hiveapi.wrapper.monthly.bd.BdMonthlyLeaderboard;
import eu.beezig.hiveapi.wrapper.monthly.bd.BdMonthlyProfile;
import eu.beezig.hiveapi.wrapper.player.Achievement;
import eu.beezig.hiveapi.wrapper.player.PvPStats;
import eu.beezig.hiveapi.wrapper.player.Titleable;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class BdStats
extends PvPStats
implements Titleable,
MonthliesReady {
    public BdStats(JObject source) {
        super(source);
    }

    public long getEnergyCollected() {
        return this.source.getLong("energy_collected");
    }

    public long getBatteriesCharged() {
        return this.source.getLong("batteries_charged");
    }

    @Override
    public List<Achievement> getAchievements() {
        return null;
    }

    @Override
    public List<Achievement> getUnlockedAchievements() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }

    public CompletableFuture<BdMonthlyProfile> getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    public CompletableFuture<BdMonthlyProfile> getMonthlyProfile(String uuid) {
        return JObject.get(new UrlBuilder().monthly().bd().profile(uuid).build()).thenApplyAsync(BdMonthlyProfile::new);
    }

    public CompletableFuture<BdMonthlyProfile> getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard(humanPlace, humanPlace).thenApplyAsync(lb -> lb.getProfiles().get(0));
    }

    public CompletableFuture<BdMonthlyLeaderboard> getMonthlyLeaderboard() {
        return JObject.get(new UrlBuilder().monthly().bd().leaderboard().build()).thenApplyAsync(BdMonthlyLeaderboard::new);
    }

    public CompletableFuture<BdMonthlyLeaderboard> getMonthlyLeaderboard(int from, int to) {
        return JObject.get(new UrlBuilder().monthly().bd().leaderboard(from, to).build()).thenApplyAsync(BdMonthlyLeaderboard::new);
    }
}

