/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player.games;

import eu.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import eu.beezig.hiveapi.wrapper.monthly.gnt.GntMonthlyLeaderboard;
import eu.beezig.hiveapi.wrapper.monthly.gnt.GntMonthlyProfile;
import eu.beezig.hiveapi.wrapper.player.PvPStats;
import eu.beezig.hiveapi.wrapper.player.Titleable;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

public class GntStats
extends PvPStats
implements Titleable,
MonthliesReady {
    public GntStats(JObject source) {
        super(source);
    }

    @Override
    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstlogin") * 1000L);
    }

    public long getGoldEarned() {
        return this.source.getLong("gold_earned");
    }

    public long getBeastsSlain() {
        return this.source.getLong("beasts_slain");
    }

    public long getShutdowns() {
        return this.source.getLong("shutdowns");
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }

    public CompletableFuture<? extends GntMonthlyProfile> getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    public CompletableFuture<? extends GntMonthlyProfile> getMonthlyProfile(String uuid) {
        return JObject.get(new UrlBuilder().monthly().gnt().profile(uuid).build()).thenApplyAsync(GntMonthlyProfile::new);
    }

    public CompletableFuture<? extends GntMonthlyProfile> getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard(humanPlace, humanPlace).thenApplyAsync(lb -> lb.getProfiles().get(0));
    }

    public CompletableFuture<? extends GntMonthlyLeaderboard> getMonthlyLeaderboard() {
        return JObject.get(new UrlBuilder().monthly().gnt().leaderboard().build()).thenApplyAsync(GntMonthlyLeaderboard::new);
    }

    public CompletableFuture<? extends GntMonthlyLeaderboard> getMonthlyLeaderboard(int from, int to) {
        return JObject.get(new UrlBuilder().monthly().gnt().leaderboard(from, to).build()).thenApplyAsync(GntMonthlyLeaderboard::new);
    }
}

