/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player.games;

import eu.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import eu.beezig.hiveapi.wrapper.monthly.dr.DrMonthlyLeaderboard;
import eu.beezig.hiveapi.wrapper.monthly.dr.DrMonthlyProfile;
import eu.beezig.hiveapi.wrapper.player.Profiles;
import eu.beezig.hiveapi.wrapper.player.PvPStats;
import eu.beezig.hiveapi.wrapper.player.Titleable;
import eu.beezig.hiveapi.wrapper.speedrun.WorldRecord;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class DrStats
extends PvPStats
implements MonthliesReady,
Titleable {
    public DrStats(JObject source) {
        super(source);
    }

    public static CompletableFuture<WorldRecord> getWorldRecord(String mapSpeedrunId) {
        return Profiles.speedrun(mapSpeedrunId);
    }

    public long getTrapsActivated() {
        return this.source.getLong("trapsactivated");
    }

    public long getVictoriesAsRunner() {
        return this.source.getLong("runnerwins");
    }

    public long getVictoriesAsDeath() {
        return this.source.getLong("deathwins");
    }

    public long getGamesPlayedAsRunner() {
        return this.source.getLong("runnergamesplayed");
    }

    public long getGamesPlayedAsDeath() {
        return this.source.getLong("deathgamesplayed");
    }

    public long getTotalCheckpoints() {
        return this.source.getLong("totalcheckpoints");
    }

    public Visibility getSelectedVisibility() {
        return Visibility.valueOf(this.source.getString("visibility"));
    }

    public Map<String, Long> getMapRecords() {
        return this.source.getJSONObject("maprecords");
    }

    public Map<String, Long> getMapKills() {
        return this.source.getJSONObject("mapkills");
    }

    public Map<String, Long> getMapDeaths() {
        return this.source.getJSONObject("mapdeaths");
    }

    public Map<String, Long> getTrapClassKills() {
        return this.source.getJSONObject("trapclasskills");
    }

    public Map<String, Long> getTrapClassDeaths() {
        return this.source.getJSONObject("trapclassdeaths");
    }

    public CompletableFuture<DrMonthlyProfile> getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    public CompletableFuture<DrMonthlyProfile> getMonthlyProfile(String uuid) {
        return JObject.get(new UrlBuilder().monthly().dr().profile(uuid).build()).thenApplyAsync(DrMonthlyProfile::new);
    }

    public CompletableFuture<DrMonthlyProfile> getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard(humanPlace, humanPlace).thenApplyAsync(lb -> lb.getProfiles().get(0));
    }

    public CompletableFuture<DrMonthlyLeaderboard> getMonthlyLeaderboard() {
        return JObject.get(new UrlBuilder().monthly().dr().leaderboard().build()).thenApplyAsync(DrMonthlyLeaderboard::new);
    }

    public CompletableFuture<DrMonthlyLeaderboard> getMonthlyLeaderboard(int from, int to) {
        return JObject.get(new UrlBuilder().monthly().dr().leaderboard(from, to).build()).thenApplyAsync(DrMonthlyLeaderboard::new);
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }

    public static enum Visibility {
        SHOW_ALL,
        RUNNERS_AS_GHOST,
        RUNNERS_INVISIBLE;

    }
}

