/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.utils.download;

import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;

public class HiveUrlBuilder
extends UrlBuilder {
    HiveUrlBuilder(UrlBuilder parent) {
        this.builder = parent.builder.append("api.hivemc.com/v1/");
    }

    public HiveUrlBuilder player(String player) {
        this.builder.append("player/").append(player);
        return this;
    }

    public HiveUrlBuilder player(String player, String game) {
        this.player(player);
        this.builder.append("/").append(game);
        return this;
    }

    public HiveUrlBuilder game(String game) {
        this.builder.append("game/").append(game);
        return this;
    }

    public HiveUrlBuilder status(String player) {
        this.player(player);
        this.builder.append("/status/raw");
        return this;
    }

    public HiveUrlBuilder maps() {
        this.builder.append("/maps");
        return this;
    }

    public HiveUrlBuilder leaderboard(int start, int end) {
        this.builder.append("/leaderboard/").append(start).append('/').append(end);
        return this;
    }

    public HiveUrlBuilder leaderboardWithVariation(String shortcode, String variation, int start, int end) {
        this.builder.append("game/").append(shortcode).append("/leaderboard/").append(start).append('/').append(end).append('/').append(variation);
        return this;
    }

    private void server(String extra) {
        this.builder.append("server/").append(extra);
    }

    public HiveUrlBuilder serverUnique() {
        this.server("/uniquecount");
        return this;
    }

    public HiveUrlBuilder serverCurrent() {
        this.server("/playercount");
        return this;
    }

    public HiveUrlBuilder serverAchievements() {
        this.server("/achievements");
        return this;
    }
}

