/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player.games;

import eu.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import eu.beezig.hiveapi.wrapper.monthly.timv.TimvMonthlyLeaderboard;
import eu.beezig.hiveapi.wrapper.monthly.timv.TimvMonthlyProfile;
import eu.beezig.hiveapi.wrapper.player.GameStats;
import eu.beezig.hiveapi.wrapper.player.Titleable;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

public class TimvStats
extends GameStats
implements MonthliesReady,
Titleable {
    public TimvStats(JObject source) {
        super(source);
    }

    public long getRolePoints() {
        return this.source.getLong("role_points");
    }

    public long getInnocentPoints() {
        return this.source.getLong("i_points");
    }

    public long getDetectivePoints() {
        return this.source.getLong("d_points");
    }

    public long getTraitorPoints() {
        return this.source.getLong("t_points");
    }

    public long getMostPoints() {
        return this.source.getLong("most_points");
    }

    @Override
    public Date getFirstLogin() {
        return null;
    }

    @Override
    public Date getCachedAt() {
        return null;
    }

    @Override
    public long getVictories() {
        return -1L;
    }

    @Override
    public long getGamesPlayed() {
        return -1L;
    }

    public boolean hasDetectiveStick() {
        return this.source.getBoolean("detectivebook");
    }

    public CompletableFuture<TimvMonthlyProfile> getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    public CompletableFuture<TimvMonthlyProfile> getMonthlyProfile(String uuid) {
        return JObject.get(new UrlBuilder().monthly().timv().profile(uuid).build()).thenApplyAsync(TimvMonthlyProfile::new);
    }

    public CompletableFuture<TimvMonthlyProfile> getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard(humanPlace, humanPlace).thenApplyAsync(lb -> lb.getProfiles().get(0));
    }

    public CompletableFuture<TimvMonthlyLeaderboard> getMonthlyLeaderboard() {
        return JObject.get(new UrlBuilder().monthly().timv().leaderboard().build()).thenApplyAsync(TimvMonthlyLeaderboard::new);
    }

    public CompletableFuture<TimvMonthlyLeaderboard> getMonthlyLeaderboard(int from, int to) {
        return JObject.get(new UrlBuilder().monthly().timv().leaderboard(from, to).build()).thenApplyAsync(TimvMonthlyLeaderboard::new);
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }
}

