/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player;

import eu.beezig.hiveapi.wrapper.mojang.UsernameToUuid;
import eu.beezig.hiveapi.wrapper.player.HivePlayer;
import eu.beezig.hiveapi.wrapper.player.games.BedStats;
import eu.beezig.hiveapi.wrapper.player.games.BpStats;
import eu.beezig.hiveapi.wrapper.player.games.CaiStats;
import eu.beezig.hiveapi.wrapper.player.games.DrStats;
import eu.beezig.hiveapi.wrapper.player.games.GntStats;
import eu.beezig.hiveapi.wrapper.player.games.GntmStats;
import eu.beezig.hiveapi.wrapper.player.games.GravStats;
import eu.beezig.hiveapi.wrapper.player.games.HideStats;
import eu.beezig.hiveapi.wrapper.player.games.LabStats;
import eu.beezig.hiveapi.wrapper.player.games.MimvStats;
import eu.beezig.hiveapi.wrapper.player.games.SgStats;
import eu.beezig.hiveapi.wrapper.player.games.SgnStats;
import eu.beezig.hiveapi.wrapper.player.games.SkyStats;
import eu.beezig.hiveapi.wrapper.player.games.TimvStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.BdStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.CrStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.DrawStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.EeStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.EfStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.HbStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.HeroStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.MmStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.OitcStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.PmkStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.RrStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.SlapStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.SpStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.SplStats;
import eu.beezig.hiveapi.wrapper.player.games.arcade.SurvStats;
import eu.beezig.hiveapi.wrapper.speedrun.WorldRecord;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.concurrent.CompletableFuture;

public class Profiles {
    private static CompletableFuture<JObject> getStats(String shortcode, String username) {
        if (username.length() < 16) {
            return UsernameToUuid.getUUID(username).thenApplyAsync(uuid -> JObject.get(new UrlBuilder().hive().player((String)uuid, shortcode).build()).join());
        }
        return JObject.get(new UrlBuilder().hive().player(username, shortcode).build());
    }

    public static CompletableFuture<HivePlayer> global(String username) {
        if (username.length() < 16) {
            return ((CompletableFuture)UsernameToUuid.getUUID(username).thenApplyAsync(uuid -> JObject.get(new UrlBuilder().hive().player((String)uuid).build()).join())).thenApplyAsync(HivePlayer::new);
        }
        return JObject.get(new UrlBuilder().hive().player(username).build()).thenApplyAsync(HivePlayer::new);
    }

    public static CompletableFuture<WorldRecord> speedrun(String levelId) {
        CompletableFuture<JObject> wrData = JObject.get(new UrlBuilder().speedrun().level(levelId).build());
        return wrData.thenApplyAsync(json -> {
            String holderId = json.getJObject("data").getJArray("runs").getJObject(0).getJObject("run").getJArray("players").getJObject(0).getString("id");
            return (WorldRecord)((CompletableFuture)JObject.get(new UrlBuilder().speedrun().user(holderId).build()).thenApplyAsync(j2 -> new WorldRecord((JObject)json, (JObject)j2))).join();
        });
    }

    public static CompletableFuture<TimvStats> timv(String username) {
        return Profiles.getStats("TIMV", username).thenApplyAsync(TimvStats::new);
    }

    public static CompletableFuture<BedStats> bed(String username) {
        return Profiles.getStats("BED", username).thenApplyAsync(BedStats::new);
    }

    public static CompletableFuture<BpStats> bp(String username) {
        return Profiles.getStats("BP", username).thenApplyAsync(BpStats::new);
    }

    public static CompletableFuture<CaiStats> cai(String username) {
        return Profiles.getStats("CAI", username).thenApplyAsync(CaiStats::new);
    }

    public static CompletableFuture<DrStats> dr(String username) {
        return Profiles.getStats("DR", username).thenApplyAsync(DrStats::new);
    }

    public static CompletableFuture<GntmStats> gntm(String username) {
        return Profiles.getStats("GNTM", username).thenApplyAsync(GntmStats::new);
    }

    public static CompletableFuture<GntStats> gnt(String username) {
        return Profiles.getStats("GNT", username).thenApplyAsync(GntStats::new);
    }

    public static CompletableFuture<GravStats> grav(String username) {
        return Profiles.getStats("GRAV", username).thenApplyAsync(GravStats::new);
    }

    public static CompletableFuture<HideStats> hide(String username) {
        return Profiles.getStats("HIDE", username).thenApplyAsync(HideStats::new);
    }

    public static CompletableFuture<LabStats> lab(String username) {
        return Profiles.getStats("LAB", username).thenApplyAsync(LabStats::new);
    }

    public static CompletableFuture<MimvStats> mimv(String username) {
        return Profiles.getStats("MIMV", username).thenApplyAsync(MimvStats::new);
    }

    public static CompletableFuture<SgnStats> sgn(String username) {
        return Profiles.getStats("SGN", username).thenApplyAsync(SgnStats::new);
    }

    public static CompletableFuture<SgStats> sg(String username) {
        return Profiles.getStats("SG", username).thenApplyAsync(SgStats::new);
    }

    public static CompletableFuture<SkyStats> sky(String username) {
        return Profiles.getStats("SKY", username).thenApplyAsync(SkyStats::new);
    }

    public static CompletableFuture<BdStats> bd(String username) {
        return Profiles.getStats("BD", username).thenApplyAsync(BdStats::new);
    }

    public static CompletableFuture<CrStats> cr(String username) {
        return Profiles.getStats("CR", username).thenApplyAsync(CrStats::new);
    }

    public static CompletableFuture<DrawStats> draw(String username) {
        return Profiles.getStats("DRAW", username).thenApplyAsync(DrawStats::new);
    }

    public static CompletableFuture<EeStats> ee(String username) {
        return Profiles.getStats("EE", username).thenApplyAsync(EeStats::new);
    }

    public static CompletableFuture<EfStats> ef(String username) {
        return Profiles.getStats("EF", username).thenApplyAsync(EfStats::new);
    }

    public static CompletableFuture<HbStats> hb(String username) {
        return Profiles.getStats("HB", username).thenApplyAsync(HbStats::new);
    }

    public static CompletableFuture<HeroStats> hero(String username) {
        return Profiles.getStats("HERO", username).thenApplyAsync(HeroStats::new);
    }

    public static CompletableFuture<MmStats> mm(String username) {
        return Profiles.getStats("MM", username).thenApplyAsync(MmStats::new);
    }

    public static CompletableFuture<OitcStats> oitc(String username) {
        return Profiles.getStats("OITC", username).thenApplyAsync(OitcStats::new);
    }

    public static CompletableFuture<PmkStats> pmk(String username) {
        return Profiles.getStats("PMK", username).thenApplyAsync(PmkStats::new);
    }

    public static CompletableFuture<RrStats> rr(String username) {
        return Profiles.getStats("RR", username).thenApplyAsync(RrStats::new);
    }

    public static CompletableFuture<SlapStats> slap(String username) {
        return Profiles.getStats("SLAP", username).thenApplyAsync(SlapStats::new);
    }

    public static CompletableFuture<SplStats> spl(String username) {
        return Profiles.getStats("SPL", username).thenApplyAsync(SplStats::new);
    }

    public static CompletableFuture<SpStats> sp(String username) {
        return Profiles.getStats("SP", username).thenApplyAsync(SpStats::new);
    }

    public static CompletableFuture<SurvStats> surv(String username) {
        return Profiles.getStats("SURV", username).thenApplyAsync(SurvStats::new);
    }
}

