/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player;

import eu.beezig.hiveapi.wrapper.player.Achievement;
import eu.beezig.hiveapi.wrapper.player.Trophy;
import eu.beezig.hiveapi.wrapper.player.rank.PlayerRank;
import eu.beezig.hiveapi.wrapper.player.status.PlayerStatus;
import eu.beezig.hiveapi.wrapper.player.status.RawPlayerStatus;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class HivePlayer {
    private JObject source;
    private String input;

    public HivePlayer(JObject source) {
        this.source = source;
    }

    public String getUsername() {
        return this.source.getString("username");
    }

    public long getTokens() {
        return this.source.getLong("tokens");
    }

    public String getUUID() {
        return this.source.getString("UUID");
    }

    public long getMedals() {
        return this.source.getLong("medals");
    }

    public long getCrates() {
        return this.source.getLong("crates");
    }

    public PlayerRank getRank() {
        return new PlayerRank(new JObject(this.source.getJSONObject("modernRank")));
    }

    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstLogin") * 1000L);
    }

    public Date getLastLogin() {
        return new Date(this.source.getLong("lastLogin") * 1000L);
    }

    public Date getLastLogout() {
        return new Date(this.source.getLong("lastLogout") * 1000L);
    }

    public Date getCachedAt() {
        return new Date(this.source.getLong("cached") * 1000L);
    }

    public PlayerStatus getStatus() {
        return new PlayerStatus(this.source.getJObject("status"));
    }

    public CompletableFuture<RawPlayerStatus> getRawStatus() {
        return JObject.get(new UrlBuilder().hive().status(this.input).build()).thenApplyAsync(RawPlayerStatus::new);
    }

    public List<Achievement> getAchievements() {
        JSONObject rawAchievements = this.source.getJSONObject("achievements");
        ArrayList<Achievement> achievements = new ArrayList<Achievement>();
        HivePlayer.parseAchievements(rawAchievements, achievements);
        return achievements;
    }

    static void parseAchievements(JSONObject rawAchievements, List<Achievement> achievements) {
        for (Object achievement : rawAchievements.entrySet()) {
            Map.Entry entry;
            if (!(achievement instanceof Map.Entry) || !((entry = (Map.Entry)achievement).getValue() instanceof JSONObject)) continue;
            achievements.add(new Achievement((String)entry.getKey(), new JObject((JSONObject)entry.getValue())));
        }
    }

    public List<Trophy> getTrophies() {
        ArrayList<Trophy> parsedTrophies = new ArrayList<Trophy>();
        JSONArray trophies = this.source.getJSONArray("trophies");
        for (Object trophy : trophies) {
            parsedTrophies.add(new Trophy(new JObject((JSONObject)trophy)));
        }
        return parsedTrophies;
    }

    public List<Achievement> getUnlockedAchievements() {
        return this.getAchievements().stream().filter(Achievement::isUnlocked).collect(Collectors.toList());
    }
}

