/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.player;

import eu.beezig.hiveapi.wrapper.player.Achievement;
import eu.beezig.hiveapi.wrapper.player.HivePlayer;
import eu.beezig.hiveapi.wrapper.player.Profiles;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.json.simple.JSONObject;

public class GameStats {
    protected JObject source;

    public GameStats(JObject source) {
        this.source = source;
    }

    public String getUUID() {
        return this.source.getString("UUID");
    }

    public long getPoints() {
        return this.source.getLong("total_points");
    }

    public long getVictories() {
        return this.source.getLong("victories");
    }

    public long getGamesPlayed() {
        return this.source.getLong("games_played");
    }

    public List<Achievement> getAchievements() {
        JSONObject rawAchievements = this.source.getJSONObject("achievements");
        ArrayList<Achievement> achievements = new ArrayList<Achievement>();
        HivePlayer.parseAchievements(rawAchievements, achievements);
        return achievements;
    }

    public List<Achievement> getUnlockedAchievements() {
        return this.getAchievements().stream().filter(Achievement::isUnlocked).collect(Collectors.toList());
    }

    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstLogin") * 1000L);
    }

    public Date getLastLogin() {
        return new Date(this.source.getLong("lastlogin") * 1000L);
    }

    public Date getCachedAt() {
        return new Date(this.source.getLong("cached") * 1000L);
    }

    public JObject getSource() {
        return this.source;
    }

    public CompletableFuture<HivePlayer> getPlayer() {
        return Profiles.global(this.source.getString("UUID"));
    }
}

