/*
 * Decompiled with CFR 0.152.
 */
package eu.beezig.hiveapi.wrapper.game;

import eu.beezig.hiveapi.wrapper.game.achievement.AchievementInfo;
import eu.beezig.hiveapi.wrapper.game.leaderboard.GameLeaderboard;
import eu.beezig.hiveapi.wrapper.game.map.GameMap;
import eu.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import eu.beezig.hiveapi.wrapper.utils.json.JObject;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Game {
    private JObject source;
    private String shortcode;

    public Game(String shortcode, JObject source) {
        this.shortcode = shortcode;
        this.source = source;
    }

    public long getUniquePlayers() {
        return this.source.getLong("uniqueplayers");
    }

    public List<AchievementInfo> getAchievements() {
        JSONArray rawAchievements = this.source.getJSONArray("achievements");
        ArrayList<AchievementInfo> achievements = new ArrayList<AchievementInfo>();
        for (Object achievement : rawAchievements) {
            if (!(achievement instanceof JSONObject)) continue;
            achievements.add(new AchievementInfo(new JObject((JSONObject)achievement)));
        }
        return achievements;
    }

    public CompletableFuture<List<GameMap>> getMaps() {
        return JObject.get(new UrlBuilder().hive().game(this.shortcode).maps().build()).thenApplyAsync(list -> {
            ArrayList<GameMap> maps = new ArrayList<GameMap>();
            JSONObject raw = list.getInput();
            for (Object map : raw.entrySet()) {
                if (!(map instanceof Map.Entry)) continue;
                Map.Entry entry = (Map.Entry)map;
                maps.add(new GameMap(new JObject((JSONObject)entry.getValue())));
            }
            return maps;
        });
    }

    public CompletableFuture<GameLeaderboard> getLeaderboard(int start, int end) {
        URL url = this.shortcode.matches("BED.") ? new UrlBuilder().hive().leaderboardWithVariation("BED", this.shortcode, start, end).build() : new UrlBuilder().hive().game(this.shortcode).leaderboard(start, end).build();
        return JObject.get(url).thenApplyAsync(GameLeaderboard::new);
    }

    public CompletableFuture<GameLeaderboard> getLeaderboard() {
        return this.getLeaderboard(0, 200);
    }
}

