/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.utils.download;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import pw.roccodev.beezig.hiveapi.wrapper.GlobalConfiguration;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JArray;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JObject;

public class Downloader {
    public JObject getJsonObject(String url) throws MalformedURLException {
        return this.getJsonObject(new URL(url));
    }

    public JArray getJsonArray(String url) throws MalformedURLException {
        return this.getJsonArray(new URL(url));
    }

    public JObject getJsonObject(URL url) {
        return new JObject((JSONObject)this.readUrl(url));
    }

    public JArray getJsonArray(URL url) {
        return new JArray((JSONArray)this.readUrl(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readUrl(URL url) {
        BufferedReader reader = null;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.addRequestProperty("User-Agent", GlobalConfiguration.USER_AGENT);
            conn.setRequestProperty("Accept", "application/json");
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.forName("UTF-8")));
            JSONParser parser = new JSONParser();
            Object object = parser.parse((Reader)reader);
            return object;
        }
        catch (Exception parser) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }
}

