/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.player.games.arcade;

import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONObject;
import pw.roccodev.beezig.hiveapi.wrapper.player.PvPStats;
import pw.roccodev.beezig.hiveapi.wrapper.player.Titleable;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JObject;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class SplStats
extends PvPStats
implements Titleable {
    private LazyObject source = this.getSource();

    public SplStats(String usernameOrUUID) {
        this(usernameOrUUID, false);
    }

    public SplStats(String username, boolean convertToUUID) {
        super(username, "SPL", convertToUUID);
    }

    public long getBlocksPainted() {
        return this.source.getLong("blockspainted");
    }

    public long getUltimatesEarned() {
        return this.source.getLong("ultimates_earned");
    }

    public HashMap<String, SploopCharacterStats> getCharacterStats() {
        HashMap<String, SploopCharacterStats> stats = new HashMap<String, SploopCharacterStats>();
        JSONObject rawStats = this.source.getJSONObject("character_stats");
        for (Object o : rawStats.entrySet()) {
            if (!(o instanceof Map.Entry)) continue;
            Map.Entry entry = (Map.Entry)o;
            stats.put((String)entry.getKey(), new SploopCharacterStats(new JObject((JSONObject)entry.getValue())));
        }
        return stats;
    }

    public SploopCharacterStats getStatsByCharacter(String raw) {
        return this.getCharacterStats().get(raw);
    }

    public SploopCharacterStats getStatsByCharacter(Character character) {
        return this.getStatsByCharacter(character.getApiKey());
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }

    public static enum Character {
        TORSTEIN("TorsteinCharacter"),
        RAVEN("RavenCharacter"),
        BOOSTER("BoosterCharacter"),
        OINKY("OinkyCharacter");

        private String apiKey;

        private Character(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getApiKey() {
            return this.apiKey;
        }
    }

    public class SploopCharacterStats {
        private JObject source;

        SploopCharacterStats(JObject source) {
            this.source = source;
        }

        public long getBlocksPainted() {
            return this.source.getLong("blocks_painted");
        }

        public long getKills() {
            return this.source.getLong("kills");
        }

        public long getDeaths() {
            return this.source.getLong("deaths");
        }

        public long getGamesPlayed() {
            return this.source.getLong("games_played");
        }

        public long getUltimateKills() {
            return this.source.getLong("ultimate_kills");
        }
    }
}

