/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.player.games;

import java.util.Date;
import java.util.Map;
import pw.roccodev.beezig.hiveapi.wrapper.player.PvPStats;
import pw.roccodev.beezig.hiveapi.wrapper.player.Titleable;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class HideStats
extends PvPStats
implements Titleable {
    private LazyObject source = this.getSource();

    public HideStats(String usernameOrUUID) {
        this(usernameOrUUID, false);
    }

    public HideStats(String username, boolean convertToUUID) {
        super(username, "HIDE", convertToUUID);
    }

    @Override
    public long getGamesPlayed() {
        return this.source.getLong("gamesplayed");
    }

    @Override
    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstlogin") * 1000L);
    }

    public long getKillsAsSeeker() {
        return this.source.getLong("seekerkills");
    }

    public long getKillsAsHider() {
        return this.source.getLong("hiderkills");
    }

    public Map<String, Long> getBlockLevels() {
        return this.source.getJSONObject("blockExperience");
    }

    public Map<String, Long> getBlockExperience() {
        return this.source.getJSONObject("rawBlockExperience");
    }

    @Override
    public long getKills() {
        return this.getKillsAsHider() + this.getKillsAsSeeker();
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }
}

