/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.player.games;

import java.util.Map;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.dr.DrMonthlyLeaderboard;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.dr.DrMonthlyProfile;
import pw.roccodev.beezig.hiveapi.wrapper.player.PvPStats;
import pw.roccodev.beezig.hiveapi.wrapper.player.Titleable;
import pw.roccodev.beezig.hiveapi.wrapper.speedrun.WorldRecord;
import pw.roccodev.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class DrStats
extends PvPStats
implements MonthliesReady,
Titleable {
    private LazyObject source = this.getSource();

    public DrStats(String usernameOrUUID) {
        this(usernameOrUUID, false);
    }

    public DrStats(String username, boolean convertToUUID) {
        super(username, "DR", convertToUUID);
    }

    public static WorldRecord getWorldRecord(String mapSpeedrunId) {
        return new WorldRecord(new LazyObject(null, new UrlBuilder().speedrun().level(mapSpeedrunId).build()));
    }

    public long getTrapsActivated() {
        return this.source.getLong("trapsactivated");
    }

    public long getVictoriesAsRunner() {
        return this.source.getLong("runnerwins");
    }

    public long getVictoriesAsDeath() {
        return this.source.getLong("deathwins");
    }

    public long getGamesPlayedAsRunner() {
        return this.source.getLong("runnergamesplayed");
    }

    public long getGamesPlayedAsDeath() {
        return this.source.getLong("deathgamesplayed");
    }

    public long getTotalCheckpoints() {
        return this.source.getLong("totalcheckpoints");
    }

    public Visibility getSelectedVisibility() {
        return Visibility.valueOf(this.source.getString("visibility"));
    }

    public Map<String, Long> getMapRecords() {
        return this.source.getJSONObject("maprecords");
    }

    public Map<String, Long> getMapKills() {
        return this.source.getJSONObject("mapkills");
    }

    public Map<String, Long> getMapDeaths() {
        return this.source.getJSONObject("mapdeaths");
    }

    public Map<String, Long> getTrapClassKills() {
        return this.source.getJSONObject("trapclasskills");
    }

    public Map<String, Long> getTrapClassDeaths() {
        return this.source.getJSONObject("trapclassdeaths");
    }

    @Override
    public DrMonthlyProfile getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    @Override
    public DrMonthlyProfile getMonthlyProfile(String uuid) {
        return this.getMonthlyLeaderboard().getProfiles().stream().filter(profile -> profile.getUUID().equals(uuid)).findAny().orElse(null);
    }

    @Override
    public DrMonthlyProfile getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard().getProfiles().stream().filter(profile -> profile.getPlace() == (long)(humanPlace - 1)).findAny().orElse(null);
    }

    @Override
    public DrMonthlyLeaderboard getMonthlyLeaderboard() {
        return new DrMonthlyLeaderboard(new LazyObject(null, new UrlBuilder().monthly().dr().build()));
    }

    @Override
    public DrMonthlyLeaderboard getMonthlyLeaderboard(int from, int to) {
        return (DrMonthlyLeaderboard)this.getMonthlyLeaderboard().filter(profile -> profile.getPlace() >= (long)from && profile.getPlace() < (long)to);
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }

    public static enum Visibility {
        SHOW_ALL,
        RUNNERS_AS_GHOST,
        RUNNERS_INVISIBLE;

    }
}

