/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.player.games;

import java.util.Date;
import pw.roccodev.beezig.hiveapi.wrapper.player.GameStats;
import pw.roccodev.beezig.hiveapi.wrapper.player.Titleable;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class CaiStats
extends GameStats
implements Titleable {
    private LazyObject source = this.getSource();

    public CaiStats(String usernameOrUUID) {
        this(usernameOrUUID, false);
    }

    public CaiStats(String username, boolean convertToUUID) {
        super(username, "CAI", convertToUUID);
    }

    @Override
    public long getGamesPlayed() {
        return this.source.getLong("gamesplayed");
    }

    public long getCaptures() {
        return this.source.getLong("captures");
    }

    public long getCaptured() {
        return this.source.getLong("captured");
    }

    public long getCatches() {
        return this.source.getLong("catches");
    }

    public long getCaught() {
        return this.source.getLong("caught");
    }

    public boolean hasTeamSelector() {
        return this.source.getBoolean("teamselector");
    }

    public boolean hasCreeperFirework() {
        return this.source.getBoolean("creeperfirework");
    }

    @Override
    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstlogin") * 1000L);
    }

    @Override
    public String getTitle() {
        return this.source.getString("title");
    }
}

