/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.json.simple.JSONObject;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.MonthlyLeaderboard;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.MaxthatMonthlyProfile;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.dr.DrMonthlyLeaderboard;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.dr.DrMonthlyProfile;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.timv.TimvMonthlyLeaderboard;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.timv.TimvMonthlyProfile;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JArray;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JObject;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class MaxthatMonthlyLeaderboard
extends MonthlyLeaderboard {
    private JObject source;
    private List<MaxthatMonthlyProfile> profiles;

    public MaxthatMonthlyLeaderboard(JObject source) {
        super(source);
        this.source = source;
    }

    public MaxthatMonthlyLeaderboard(List<MaxthatMonthlyProfile> profiles) {
        super(null);
        this.profiles = profiles;
    }

    public List<? extends MaxthatMonthlyProfile> getProfiles() {
        if (this.profiles != null) {
            return this.profiles;
        }
        if (this.source instanceof LazyObject) {
            ((LazyObject)this.source).fetch();
        }
        this.profiles = new ArrayList<MaxthatMonthlyProfile>();
        JArray rawLeaderboard = this.source.getJArray("leaderboard");
        for (Object o : rawLeaderboard.getInput()) {
            JSONObject profile = (JSONObject)o;
            if (this instanceof TimvMonthlyLeaderboard) {
                this.profiles.add(new TimvMonthlyProfile(new JObject(profile), rawLeaderboard.getInput().indexOf(o)));
                continue;
            }
            this.profiles.add(new DrMonthlyProfile(new JObject(profile), rawLeaderboard.getInput().indexOf(o)));
        }
        return this.profiles;
    }

    public MaxthatMonthlyLeaderboard filter(Predicate<MaxthatMonthlyProfile> condition) {
        if (this instanceof TimvMonthlyLeaderboard) {
            return new TimvMonthlyLeaderboard(this.getProfiles().stream().filter(condition).collect(Collectors.toList()));
        }
        return new DrMonthlyLeaderboard(this.getProfiles().stream().filter(condition).collect(Collectors.toList()));
    }
}

