/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.game.achievement;

import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JObject;

public class AchievementInfo {
    private JObject source;

    public AchievementInfo(JObject source) {
        this.source = source;
    }

    public String getEnumName() {
        return this.source.getString("name");
    }

    public String getPublicName() {
        return this.source.getString("publicname");
    }

    public String getDescription() {
        return this.source.getString("description");
    }

    public int getStages() {
        return this.source.getInt("stages");
    }

    public boolean isSecret() {
        return this.source.getBoolean("secret");
    }

    public boolean isCustom() {
        return this.source.getBoolean("custom");
    }

    public boolean isDisabled() {
        return this.source.getBoolean("disabled");
    }

    public RewardType getRewardType() {
        return RewardType.get(this.source.getString("rewardtype"));
    }

    public String getRewardArguments() {
        return this.source.getString("rewardarguments");
    }

    public static enum RewardType {
        NONE,
        BANNER,
        TOKEN,
        UNKNOWN;


        public static RewardType get(String query) {
            for (RewardType type : RewardType.values()) {
                if (!type.toString().equals(query)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }
}

