/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.game;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import pw.roccodev.beezig.hiveapi.wrapper.game.achievement.AchievementInfo;
import pw.roccodev.beezig.hiveapi.wrapper.game.leaderboard.GameLeaderboard;
import pw.roccodev.beezig.hiveapi.wrapper.game.map.GameMap;
import pw.roccodev.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JObject;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class Game {
    private LazyObject source;
    private String shortcode;

    public Game(String shortcode) {
        this.shortcode = shortcode;
        this.source = new LazyObject(null, new UrlBuilder().hive().game(shortcode).build());
    }

    public long getUniquePlayers() {
        return this.source.getLong("uniqueplayers");
    }

    public List<AchievementInfo> getAchievements() {
        JSONArray rawAchievements = this.source.getJSONArray("achievements");
        ArrayList<AchievementInfo> achievements = new ArrayList<AchievementInfo>();
        for (Object achievement : rawAchievements) {
            if (!(achievement instanceof JSONObject)) continue;
            achievements.add(new AchievementInfo(new JObject((JSONObject)achievement)));
        }
        return achievements;
    }

    public List<GameMap> getMaps() {
        ArrayList<GameMap> maps = new ArrayList<GameMap>();
        LazyObject mapsList = new LazyObject(null, new UrlBuilder().hive().game(this.shortcode).maps().build());
        mapsList.fetch();
        JSONObject raw = mapsList.getInput();
        for (Object map : raw.entrySet()) {
            if (!(map instanceof Map.Entry)) continue;
            Map.Entry entry = (Map.Entry)map;
            maps.add(new GameMap(new JObject((JSONObject)entry.getValue())));
        }
        return maps;
    }

    public GameLeaderboard getLeaderboard(int start, int end) {
        URL url = this.shortcode.matches("BED.") ? new UrlBuilder().hive().leaderboardWithVariation("BED", this.shortcode, start, end).build() : new UrlBuilder().hive().game(this.shortcode).leaderboard(start, end).build();
        return new GameLeaderboard(new LazyObject(null, url));
    }

    public GameLeaderboard getLeaderboard() {
        return this.getLeaderboard(0, 200);
    }
}

