/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.player.games;

import pw.roccodev.beezig.hiveapi.wrapper.monthly.MonthliesReady;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.dr.DrMonthlyLeaderboard;
import pw.roccodev.beezig.hiveapi.wrapper.monthly.maxthat.dr.DrMonthlyProfile;
import pw.roccodev.beezig.hiveapi.wrapper.player.PvPStats;
import pw.roccodev.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class DR
extends PvPStats
implements MonthliesReady {
    private LazyObject source = this.getSource();

    public DR(String usernameOrUUID) {
        super(usernameOrUUID, "BED");
    }

    public long getTrapsActivated() {
        return this.source.getLong("trapsactivated");
    }

    public long getVictoriesAsRunner() {
        return this.source.getLong("runnerwins");
    }

    public long getVictoriesAsDeath() {
        return this.source.getLong("deathwins");
    }

    public long getGamesPlayedAsRunner() {
        return this.source.getLong("runnergamesplayed");
    }

    public long getGamesPlayedAsDeath() {
        return this.source.getLong("deathgamesplayed");
    }

    public long getTotalCheckpoints() {
        return this.source.getLong("totalcheckpoints");
    }

    @Override
    public DrMonthlyProfile getMonthlyProfile() {
        return this.getMonthlyProfile(this.getUUID());
    }

    @Override
    public DrMonthlyProfile getMonthlyProfile(String uuid) {
        return this.getMonthlyLeaderboard().getProfiles().stream().filter(profile -> profile.getUUID().equals(uuid)).findAny().orElse(null);
    }

    @Override
    public DrMonthlyProfile getMonthlyProfile(int humanPlace) {
        return this.getMonthlyLeaderboard().getProfiles().stream().filter(profile -> profile.getPlace() == (long)(humanPlace - 1)).findAny().orElse(null);
    }

    @Override
    public DrMonthlyLeaderboard getMonthlyLeaderboard() {
        return new DrMonthlyLeaderboard(new LazyObject(null, new UrlBuilder().monthly().dr().build()));
    }

    @Override
    public DrMonthlyLeaderboard getMonthlyLeaderboard(int from, int to) {
        return (DrMonthlyLeaderboard)this.getMonthlyLeaderboard().filter(profile -> profile.getPlace() >= (long)from && profile.getPlace() < (long)to);
    }
}

