/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.player;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.simple.JSONObject;
import pw.roccodev.beezig.hiveapi.wrapper.player.Achievement;
import pw.roccodev.beezig.hiveapi.wrapper.player.rank.PlayerRank;
import pw.roccodev.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.JObject;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class HivePlayer {
    private LazyObject source;

    public HivePlayer(String usernameOrUUID) {
        this.source = new LazyObject(null, new UrlBuilder().hive().player(usernameOrUUID).build());
    }

    public String getUsername() {
        return this.source.getString("username");
    }

    public long getTokens() {
        return this.source.getLong("tokens");
    }

    public String getUUID() {
        return this.source.getString("UUID");
    }

    public long getMedals() {
        return this.source.getLong("medals");
    }

    public long getCrates() {
        return this.source.getLong("crates");
    }

    public PlayerRank getRank() {
        return new PlayerRank(new JObject(this.source.getJSONObject("modernRank")));
    }

    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstLogin") * 1000L);
    }

    public Date getLastLogin() {
        return new Date(this.source.getLong("lastLogin") * 1000L);
    }

    public Date getLastLogout() {
        return new Date(this.source.getLong("lastLogout") * 1000L);
    }

    public Date getCachedAt() {
        return new Date(this.source.getLong("cached") * 1000L);
    }

    public List<Achievement> getAchievements() {
        JSONObject rawAchievements = this.source.getJSONObject("achievements");
        ArrayList<Achievement> achievements = new ArrayList<Achievement>();
        HivePlayer.parseAchievements(rawAchievements, achievements);
        return achievements;
    }

    static void parseAchievements(JSONObject rawAchievements, List<Achievement> achievements) {
        for (Object achievement : rawAchievements.entrySet()) {
            Map.Entry entry;
            if (!(achievement instanceof Map.Entry) || !((entry = (Map.Entry)achievement).getValue() instanceof JSONObject)) continue;
            achievements.add(new Achievement((String)entry.getKey(), new JObject((JSONObject)entry.getValue())));
        }
    }

    public List<Achievement> getUnlockedAchievements() {
        return this.getAchievements().stream().filter(Achievement::isUnlocked).collect(Collectors.toList());
    }
}

