/*
 * Decompiled with CFR 0.152.
 */
package pw.roccodev.beezig.hiveapi.wrapper.player;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.json.simple.JSONObject;
import pw.roccodev.beezig.hiveapi.wrapper.game.Game;
import pw.roccodev.beezig.hiveapi.wrapper.player.Achievement;
import pw.roccodev.beezig.hiveapi.wrapper.player.HivePlayer;
import pw.roccodev.beezig.hiveapi.wrapper.utils.download.UrlBuilder;
import pw.roccodev.beezig.hiveapi.wrapper.utils.json.LazyObject;

public class GameStats {
    private LazyObject source;
    private String usernameOrUUID;
    private String shortcode;

    public GameStats(String usernameOrUUID, String shortcode) {
        this.usernameOrUUID = usernameOrUUID;
        this.shortcode = shortcode;
        this.source = new LazyObject(null, new UrlBuilder().hive().player(usernameOrUUID, shortcode).build());
    }

    public String getUUID() {
        return this.source.getString("UUID");
    }

    public long getPoints() {
        return this.source.getLong("total_points");
    }

    public long getVictories() {
        return this.source.getLong("victories");
    }

    public long getGamesPlayed() {
        return this.source.getLong("games_played");
    }

    public String getTitle() {
        return this.source.getString("title");
    }

    public List<Achievement> getAchievements() {
        JSONObject rawAchievements = this.source.getJSONObject("achievements");
        ArrayList<Achievement> achievements = new ArrayList<Achievement>();
        HivePlayer.parseAchievements(rawAchievements, achievements);
        return achievements;
    }

    public List<Achievement> getUnlockedAchievements() {
        return this.getAchievements().stream().filter(Achievement::isUnlocked).collect(Collectors.toList());
    }

    public Date getFirstLogin() {
        return new Date(this.source.getLong("firstLogin") * 1000L);
    }

    public Date getLastLogin() {
        return new Date(this.source.getLong("lastlogin") * 1000L);
    }

    public Date getCachedAt() {
        return new Date(this.source.getLong("cached") * 1000L);
    }

    public LazyObject getSource() {
        return this.source;
    }

    public HivePlayer getPlayer() {
        return new HivePlayer(this.usernameOrUUID);
    }

    public Game getGameMode() {
        return new Game(this.shortcode);
    }
}

