/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.myers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pw.prok.kdiff.Chunk;
import pw.prok.kdiff.Patch;
import pw.prok.kdiff.PatchResult;
import pw.prok.kdiff.delta.Delta;
import pw.prok.kdiff.diff.DiffAlgorithm;
import pw.prok.kdiff.diff.Equalizer;
import pw.prok.kdiff.myers.DiffNode;
import pw.prok.kdiff.myers.DifferentiationFailedException;
import pw.prok.kdiff.myers.PathNode;
import pw.prok.kdiff.myers.Snake;

public class MyersDiff<T, R extends PatchResult<T>>
implements DiffAlgorithm<T, R> {
    private final Equalizer<T> equalizer;

    public MyersDiff() {
        this.equalizer = Equalizer.DEFAULT_EQUALIZER;
    }

    public MyersDiff(Equalizer<T> equalizer) {
        if (equalizer == null) {
            throw new IllegalArgumentException("equalizer must not be null");
        }
        this.equalizer = equalizer;
    }

    @Override
    public Patch<T, R> diff(T[] original, T[] revised) {
        return this.diff(Arrays.asList(original), Arrays.asList(revised));
    }

    @Override
    public Patch<T, R> diff(List<T> original, List<T> revised) {
        if (original == null) {
            throw new IllegalArgumentException("original list must not be null");
        }
        if (revised == null) {
            throw new IllegalArgumentException("revised list must not be null");
        }
        try {
            PathNode path = this.buildPath(original, revised);
            return this.buildRevision(path, original, revised);
        }
        catch (DifferentiationFailedException e) {
            e.printStackTrace();
            return new Patch();
        }
    }

    public PathNode buildPath(List<T> orig, List<T> rev) throws DifferentiationFailedException {
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                if (k == -d || k != d && diagonal[kminus].original < diagonal[kplus].original) {
                    i = diagonal[kplus].original;
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].original + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && this.equals(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i > node.original) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    private boolean equals(T orig, T rev) {
        return this.equalizer.equals(orig, rev);
    }

    public Patch<T, R> buildRevision(PathNode path, List<T> orig, List<T> rev) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        Patch patch = new Patch();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.revised >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.original;
            int j = path.revised;
            path = path.prev;
            int ianchor = path.original;
            int janchor = path.revised;
            Chunk<T> original = new Chunk<T>(ianchor, this.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, this.copyOfRange(rev, janchor, j));
            patch.addDelta(new Delta<T>(original, revised));
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return patch;
    }

    private List<T> copyOfRange(List<T> original, int fromIndex, int to) {
        return new ArrayList<T>(original.subList(fromIndex, to));
    }
}

