/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.diff.parsers;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pw.prok.kdiff.diff.DiffException;
import pw.prok.kdiff.diff.DiffParser;
import pw.prok.kdiff.diff.DiffRow;
import pw.prok.kdiff.diff.DiffVisitor;

public class UnifedDiffParser<Visitor extends DiffVisitor<String, String>>
extends DiffParser<String, String, Visitor> {
    public static final UnifedDiffParser<DiffVisitor<String, String>> INSTANCE = new UnifedDiffParser();
    private static final Pattern CHUNK_PATTERN = Pattern.compile("^@@\\s*-(?<origpos>\\d+)(\\s*,\\s*(?<origlen>\\d+))?\\s+\\+(?<revipos>\\d+)(\\s*,\\s*(?<revilen>\\d+))?\\s*@@$");

    @Override
    public void parse(List<String> elements, Visitor visitor) throws DiffException {
        Iterator<String> iterator = elements.iterator();
        boolean next = true;
        while (iterator.hasNext() && next) {
            Matcher matcher;
            String element = iterator.next();
            if (element.startsWith("---")) {
                next = this.splitFilename(element, visitor, true);
                continue;
            }
            if (element.startsWith("+++")) {
                next = this.splitFilename(element, visitor, false);
                continue;
            }
            if (!element.startsWith("@@") || !(matcher = CHUNK_PATTERN.matcher(element)).matches()) continue;
            int originalPosition = Integer.parseInt(matcher.group("origpos"));
            int revisedPosition = Integer.parseInt(matcher.group("revipos"));
            String origLen = matcher.group("origlen");
            String reviLen = matcher.group("revilen");
            int originalLength = origLen == null ? 1 : Integer.parseInt(origLen);
            int revisedLength = reviLen == null ? 1 : Integer.parseInt(reviLen);
            next = visitor.visitChunkStart(originalPosition, originalLength, revisedPosition, revisedLength);
            int original = 0;
            int revised = 0;
            while ((original < originalLength || revised < revisedLength) && iterator.hasNext()) {
                element = iterator.next();
                if (element.length() > 0) {
                    char tag = element.charAt(0);
                    String line = element.substring(1);
                    switch (tag) {
                        case '+': {
                            ++revised;
                            next = visitor.visitLine(DiffRow.Tag.INSERT, (String)line);
                            break;
                        }
                        case '-': {
                            ++original;
                            next = visitor.visitLine(DiffRow.Tag.DELETE, (String)line);
                            break;
                        }
                        default: {
                            ++original;
                            ++revised;
                            next = visitor.visitLine(DiffRow.Tag.EQUAL, (String)line);
                            break;
                        }
                    }
                } else {
                    ++original;
                    ++revised;
                    next = visitor.visitLine(DiffRow.Tag.EQUAL, (String)"");
                }
                if (next) continue;
            }
            if (!next) break;
            if (original != originalLength || revised != revisedLength) {
                new DiffException("Length mismatch: @@ " + originalPosition + "," + originalLength + " " + revisedPosition + "," + revisedLength + " @@ " + original + "/" + revised).printStackTrace();
            }
            next = visitor.visitChunkEnd(originalPosition, originalLength, revisedPosition, revisedLength);
        }
    }

    private boolean splitFilename(String element, Visitor visitor, boolean original) throws DiffException {
        Date date = null;
        int idx = element.lastIndexOf("  ");
        if (idx > 0) {
            try {
                date = UnifedDiffDateFormat.INSTANCE.parse(element.substring(idx + 2));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            element = element.substring(3, idx).trim();
        } else {
            element = element.substring(3).trim();
        }
        if (original) {
            return visitor.visitOriginal(element, date);
        }
        return visitor.visitRevised(element, date);
    }

    public static class UnifedDiffDateFormat
    extends DateFormat {
        public static final UnifedDiffDateFormat INSTANCE = new UnifedDiffDateFormat();
        private static final Pattern PATTERN = Pattern.compile("^(?<year>\\d{4})-(?<month>\\d{2})-(?<day>\\d{2}) (?<hour>\\d{2}):(?<minute>\\d{2}):(?<second>\\d{2}).(?<millisecond>\\d{9}) (?<tzsign>\\+|-)(?<tzhour>\\d{2})(?<tzminute>\\d{2})$");
        private static final String FORMAT = "%04d-%02d-%02d %02d:%02d:%02d.%09d %s%02d%02d";

        @Override
        public StringBuffer format(Date date, StringBuffer buffer, FieldPosition position) {
            Calendar calendar = Calendar.getInstance(Locale.US);
            calendar.setTime(date);
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            int hour = calendar.get(10);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            int millisecond = calendar.get(14) * 1000000;
            int offset = calendar.getTimeZone().getRawOffset();
            String tzsign = offset >= 0 ? "+" : "-";
            int tzhour = offset / 3600000;
            int tzminute = offset % 3600000;
            buffer.append(String.format(FORMAT, year, month, day, hour, minute, second, millisecond, tzsign, tzhour, tzminute));
            return buffer;
        }

        @Override
        public Date parse(String s, ParsePosition position) {
            Matcher matcher = PATTERN.matcher(s.subSequence(position.getIndex(), s.length()));
            if (!matcher.matches()) {
                return null;
            }
            position.setIndex(position.getIndex() + matcher.end());
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC" + matcher.group("tzsign") + matcher.group("tzhour") + ":" + matcher.group("tzminute")), Locale.US);
            calendar.set(1, Integer.parseInt(matcher.group("year")));
            calendar.set(2, Integer.parseInt(matcher.group("month")));
            calendar.set(5, Integer.parseInt(matcher.group("day")));
            calendar.set(10, Integer.parseInt(matcher.group("hour")));
            calendar.set(12, Integer.parseInt(matcher.group("minute")));
            calendar.set(13, Integer.parseInt(matcher.group("second")));
            calendar.set(14, Integer.parseInt(matcher.group("millisecond")) / 1000000);
            return calendar.getTime();
        }
    }
}

