/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.delta;

import java.util.List;
import pw.prok.kdiff.Chunk;
import pw.prok.kdiff.Hunk;
import pw.prok.kdiff.PatchFailedException;
import pw.prok.kdiff.diff.DiffException;

public class Delta<T> {
    private Chunk<T> original;
    private Chunk<T> revised;

    public Delta(Chunk<T> original, Chunk<T> revised) {
        if (original == null) {
            throw new IllegalArgumentException("original must not be null");
        }
        if (revised == null) {
            throw new IllegalArgumentException("revised must not be null");
        }
        this.original = original;
        this.revised = revised;
    }

    public Hunk<T> patch(List<T> target) throws PatchFailedException {
        try {
            int offset = this.getOriginal().applyHunk(target);
            int original = this.getOriginal().getPosition();
            Delta.patch(target, original + offset, this.getOriginal().getLines(), this.getRevised().getLines());
            return offset == 0 ? null : new Hunk(this, offset);
        }
        catch (DiffException e) {
            throw new PatchFailedException(e);
        }
    }

    public Hunk<T> restore(List<T> target) throws PatchFailedException {
        try {
            int offset = this.getRevised().applyHunk(target);
            int revised = this.getRevised().getPosition();
            Delta.patch(target, revised + offset, this.getRevised().getLines(), this.getOriginal().getLines());
            return offset == 0 ? null : new Hunk(this, offset);
        }
        catch (DiffException e) {
            throw new PatchFailedException(e);
        }
    }

    private static <T> void patch(List<T> target, int position, List<T> from, List<T> to) {
        target.subList(position, position + from.size()).clear();
        target.addAll(position, to);
    }

    public DeltaType getType() {
        if (this.getOriginal().size() == 0) {
            return DeltaType.INSERT;
        }
        if (this.getRevised().size() == 0) {
            return DeltaType.DELETE;
        }
        return DeltaType.CHANGE;
    }

    public Chunk<T> getOriginal() {
        return this.original;
    }

    public void setOriginal(Chunk<T> original) {
        this.original = original;
    }

    public Chunk<T> getRevised() {
        return this.revised;
    }

    public void setRevised(Chunk<T> revised) {
        this.revised = revised;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
        result = 31 * result + (this.revised == null ? 0 : this.revised.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Delta other = (Delta)obj;
        if (this.original == null ? other.original != null : !this.original.equals(other.original)) {
            return false;
        }
        return !(this.revised == null ? other.revised != null : !this.revised.equals(other.revised));
    }

    public Delta<T> copy() {
        return new Delta<T>(this.original.copy(), this.revised.copy());
    }

    public static enum DeltaType {
        CHANGE,
        DELETE,
        INSERT;

    }
}

