/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import pw.prok.kdiff.PatchFailedException;
import pw.prok.kdiff.diff.DiffException;
import pw.prok.kdiff.diff.Equalizer;

public class Chunk<T> {
    private final int position;
    private List<T> lines;

    public Chunk(int position, List<T> lines) {
        this.position = position;
        this.lines = lines;
    }

    public Chunk(int position, T[] lines) {
        this.position = position;
        this.lines = Arrays.asList(lines);
    }

    public void verify(List<T> target) throws PatchFailedException {
        try {
            this.applyHunk(target);
        }
        catch (DiffException e) {
            throw new PatchFailedException(e);
        }
    }

    public int applyHunk(List<T> target) throws DiffException {
        return this.applyHunk(target, 0);
    }

    public int applyHunk(List<T> target, int lastOffset) throws DiffException {
        return this.applyHunk(target, lastOffset, Equalizer.DEFAULT_EQUALIZER);
    }

    public int applyHunk(List<T> target, int lastOffset, Equalizer<T> equalizer) throws DiffException {
        int actual = Chunk.search(target, this.lines, this.position + lastOffset, equalizer);
        if (actual < 0) {
            throw new DiffException("Hunk cannot be applied");
        }
        return actual - this.position;
    }

    private static <T> int search(List<T> where, List<T> what, int point, Equalizer<T> equalizer) {
        boolean start = false;
        int end = where.size() - what.size();
        if (end < 0) {
            return -1;
        }
        if (Chunk.equals(where, what, point, equalizer)) {
            return point;
        }
        int i = 1;
        while (point - i >= 0 || point + i <= end) {
            if (point - i >= 0 && Chunk.equals(where, what, point - i, equalizer)) {
                return point - i;
            }
            if (point + i <= end && Chunk.equals(where, what, point + i, equalizer)) {
                return point + i;
            }
            ++i;
        }
        return -1;
    }

    private static <T> boolean equals(List<T> where, List<T> what, int point, Equalizer<T> equalizer) {
        for (int i = 0; i < what.size(); ++i) {
            T o2;
            T o1 = where.get(point + i);
            if (equalizer.equals(o1, o2 = what.get(i))) continue;
            return false;
        }
        return true;
    }

    public int getPosition() {
        return this.position;
    }

    public void setLines(List<T> lines) {
        this.lines = lines;
    }

    public List<T> getLines() {
        return this.lines;
    }

    public int size() {
        return this.lines.size();
    }

    public int last() {
        return this.getPosition() + this.size() - 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lines == null ? 0 : this.lines.hashCode());
        result = 31 * result + this.position;
        result = 31 * result + this.size();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chunk other = (Chunk)obj;
        if (this.lines == null ? other.lines != null : !this.lines.equals(other.lines)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return "[position: " + this.position + ", size: " + this.size() + ", lines: " + this.lines + "]";
    }

    public Chunk<T> copy() {
        return new Chunk<T>(this.position, new ArrayList<T>(this.lines));
    }
}

