package pw.prok.kdiff.myers;

/**
 * A diffnode in a diffpath.
 * <p>
 * A DiffNode and its previous node mark a delta between
 * two input sequences, that is, two differing subsequences
 * between (possibly zero length) matching sequences.
 * <p>
 * {@link DiffNode DiffNodes} and {@link Snake Snakes} allow for compression
 * of diffpaths, as each snake is represented by a single {@link Snake Snake}
 * node and each contiguous series of insertions and deletions is represented
 * by a single {@link DiffNode DiffNodes}.
 */
public final class DiffNode extends PathNode {
    /**
     * Constructs a DiffNode.
     * <p>
     * DiffNodes are compressed. That means that
     * the path pointed to by the <code>prev</code> parameter
     * will be followed using {@link PathNode#previousSnake}
     * until a non-diff node is found.
     *
     * @param original the  position in the original sequence
     * @param revised  the  position in the revised sequence
     * @param prev     the previous node in the path.
     */
    public DiffNode(int original, int revised, PathNode prev) {
        super(original, revised, (prev == null ? null : prev.previousSnake()));
    }

    /**
     * {@inheritDoc}
     *
     * @return false, always
     */
    public boolean isSnake() {
        return false;
    }
}