package pw.prok.kdiff.diff;

/**
 * Specifies when two compared elements in the Myers algorithm are equal.
 *
 * @param <T> The type of the compared elements in the 'lines'.
 */
public interface Equalizer<T> {
    /**
     * Default equalizer. Using {@link Object#equals(Object)} to compare objects.
     */
    Equalizer<?> DEFAULT_EQUALIZER = new Equalizer<Object>() {
        public boolean equals(final Object original, final Object revised) {
            if (original == null) return revised == null;
            return original.equals(revised);
        }
    };

    /**
     * Indicates if two elements are equal according to the diff mechanism.
     *
     * @param original The original element. Must not be {@code null}.
     * @param revised  The revised element. Must not be {@code null}.
     * @return Returns true if the elements are equal.
     */
    boolean equals(T original, T revised);
}
