package pw.prok.kdiff.diff;

import java.util.Date;

public interface DiffVisitor<T, C> {
    boolean visitComment(C comment);

    boolean visitOriginal(String original, Date date) throws DiffException;

    boolean visitRevised(String revised, Date date) throws DiffException;

    boolean visitChunkStart(int originalPosition, int originalCount, int revisedPosition, int revisedCount);

    boolean visitChunkEnd(int originalPosition, int originalCount, int revisedPosition, int revisedCount);

    boolean visitLine(DiffRow.Tag tag, T line);
}
