package pw.prok.kdiff;

import pw.prok.kdiff.delta.Delta;

import java.util.List;

public class PatchResult<T> {
    private final List<T> result;
    private final List<Hunk<T>> hunks;
    private final List<Delta<T>> rejects;

    public PatchResult(List<T> result, List<Hunk<T>> hunks, List<Delta<T>> rejects) {
        this.result = result;
        this.hunks = hunks;
        this.rejects = rejects;
    }

    public List<T> getResult() {
        return result;
    }

    public List<Hunk<T>> getHunks() {
        return hunks;
    }

    public List<Delta<T>> getRejects() {
        return rejects;
    }
}
