package pw.prok.kdiff;

public abstract class Pair<F, S> {
    public abstract F getFirst();

    public abstract S getSecond();

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Pair && equals(getFirst(), ((Pair) o).getFirst()) && equals(getSecond(), ((Pair) o).getSecond());
    }

    @Override
    public int hashCode() {
        return hashCode(getFirst()) ^ hashCode(getSecond());
    }

    private static int hashCode(Object o) {
        if (o == null) return 0;
        return o.hashCode();
    }

    private static boolean equals(Object o1, Object o2) {
        if (o1 == null) return o2 == null;
        return o1.equals(o2);
    }

    public static <F, S> MutablePair<F, S> mutable() {
        return new MutablePair<F, S>();
    }

    public static <F, S> MutablePair<F, S> mutable(F first, S second) {
        return new MutablePair<F, S>(first, second);
    }

    public static <F, S> ImmutablePair<F, S> immutable(F first, S second) {
        return new ImmutablePair<F, S>(first, second);
    }

    public static final class MutablePair<F, S> extends Pair<F, S> {
        private F first;
        private S second;

        MutablePair() {

        }

        MutablePair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public F getFirst() {
            return first;
        }

        public MutablePair setFirst(F first) {
            this.first = first;
            return this;
        }

        @Override
        public S getSecond() {
            return second;
        }

        public MutablePair setSecond(S second) {
            this.second = second;
            return this;
        }
    }

    public static final class ImmutablePair<F, S> extends Pair<F, S> {
        private final F first;
        private final S second;

        public ImmutablePair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public F getFirst() {
            return first;
        }

        @Override
        public S getSecond() {
            return second;
        }
    }
}
