package pw.prok.kdiff;

import pw.prok.kdiff.delta.Delta;

/**
 * Represents hunk of delta
 *
 * @param <T> element type
 */
public class Hunk<T> {
    private final Delta<T> delta;
    private final int offset;

    public Hunk(Delta<T> delta, int offset) {
        this.delta = delta;
        this.offset = offset;
    }

    public Delta<T> getDelta() {
        return delta;
    }

    public int getOriginalPosition() {
        return delta.getOriginal().getPosition();
    }

    public int getOffset() {
        return offset;
    }

    public int getRevisedPosition() {
        return delta.getOriginal().getPosition() + offset;
    }
}
