/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.myers;

public abstract class PathNode {
    public final int original;
    public final int revised;
    public final PathNode prev;

    public PathNode(int original, int revised, PathNode prev) {
        this.original = original;
        this.revised = revised;
        this.prev = prev;
    }

    public abstract boolean isSnake();

    public boolean isBootstrap() {
        return this.original < 0 || this.revised < 0;
    }

    public final PathNode previousSnake() {
        if (this.isBootstrap()) {
            return null;
        }
        if (!this.isSnake() && this.prev != null) {
            return this.prev.previousSnake();
        }
        return this;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        PathNode node = this;
        while (node != null) {
            buf.append("(");
            buf.append(Integer.toString(node.original));
            buf.append(",");
            buf.append(Integer.toString(node.revised));
            buf.append(")");
            node = node.prev;
        }
        buf.append("]");
        return buf.toString();
    }
}

