/*
 * Decompiled with CFR 0.152.
 */
package pw.prok.kdiff.diff.visitors;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import pw.prok.kdiff.Patch;
import pw.prok.kdiff.PatchResult;
import pw.prok.kdiff.diff.DiffException;
import pw.prok.kdiff.diff.visitors.MappedVisitor;

public class SimpleVisitor<T, C>
extends MappedVisitor<T, C> {
    boolean originalVisited = false;
    boolean revisedVisited = false;

    @Override
    public boolean visitOriginal(String original, Date date) throws DiffException {
        System.out.println("ORIGINAL: " + original + " " + date);
        if (this.originalVisited && !this.originalFilename.equals(original)) {
            throw new DiffException("Original name already visited!");
        }
        this.originalVisited = true;
        return super.visitOriginal(original, date);
    }

    @Override
    public boolean visitRevised(String revised, Date date) throws DiffException {
        System.out.println("REVISED: " + revised + " " + date);
        if (this.revisedVisited && !this.revisedFilename.equals(revised)) {
            throw new DiffException("Revised name already visited!");
        }
        this.revisedVisited = true;
        return super.visitRevised(revised, date);
    }

    public Patch<T, PatchResult<T>> getPatch() {
        Collection values = this.getMap().values();
        if (values.size() > 1) {
            throw new RuntimeException(new DiffException("What? More than one patch? Seriously?"));
        }
        Iterator iterator = values.iterator();
        if (iterator.hasNext()) {
            Patch patch = iterator.next();
            return patch;
        }
        return new Patch();
    }
}

